//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * IuWFNgAj[Vwb_
 * @author Junpee
 */

#ifndef OBJECT_ANIMATION_H_
#define OBJECT_ANIMATION_H_

#include <Animation/System/Animation.h>
#include <Animation/System/AnimationData.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * IuWFNgAj[V
 */
class ObjectAnimation  : public Animation{
public:
	//--------------------------------------------------------------------------
	// Aj[Vf[^
	//--------------------------------------------------------------------------
	/**
	 * Aj[Vf[^̎擾
	 * @return Aj[Vf[^
	 */
	virtual AnimationData* getAnimationData() = 0;

	/**
	 * Aj[Vf[^̎擾
	 * @return Aj[Vf[^
	 */
	virtual const AnimationData* getAnimationData() const = 0;

	//--------------------------------------------------------------------------
	// ^[Qbg
	//--------------------------------------------------------------------------
	/**
	 * ^[Qbg̐ݒ
	 * @param targetName ݒ肷^[Qbg
	 */
	virtual void setTargetName(const String& targetName){
		targetName_ = targetName;
	}

	/**
	 * ^[Qbg̎擾
	 * @return ^[Qbg
	 */
	virtual const String& getTargetName() const{ return targetName_; }

	//--------------------------------------------------------------------------
	// V[PX
	//--------------------------------------------------------------------------
	/**
	 * V[PX̎擾
	 * @return V[PX
	 */
	virtual int getSequenceCount() const{
		const AnimationData* data = getAnimationData();
		if(data == NULL){ return 0; }
		return data->getSequenceCount();
	}

	/**
	 * V[PX̐ݒ
	 * @param sequence ݒ肷V[PX
	 * @param time ݒ肷鎞
	 */
	virtual void setSequence(int sequence, float time = 0.f){
		Assert(sequence >= 0);
		Assert((sequence == 0) || (sequence < getSequenceCount()));
		sequence_ = sequence;
		setTime(time);
	}

	/**
	 * V[PX̎擾
	 * @return V[PX
	 */
	virtual int getSequence() const{ return sequence_; }

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * Ԃ̐ݒ
	 * @param time ݒ肷鎞
	 */
	virtual void setTime(float time){ time_ = time; }

	/**
	 * Ԃ̎擾
	 * @return 
	 */
	virtual float getTime() const{ return time_; }

	//--------------------------------------------------------------------------
	// Aj[V
	//--------------------------------------------------------------------------
	/**
	 * IĂ邩
	 * @return IĂtrue
	 */
	virtual bool isFinished() const{
		if(getAnimationData() == NULL){ return true; }
		// [vAj[V̓V[PXΏItO
		return (getTime() >= getLength());
	}

	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const{
		const AnimationData* data = getAnimationData();
		if(data == NULL){ return 0.f; }
		return data->getLength(getSequence());
	}

	/**
	 * [vĂ邩
	 * @return [vĂtrue
	 */
	virtual bool isLooped() const{
		const AnimationData* data = getAnimationData();
		if(data == NULL){ return false; }
		return data->isLooped(getSequence());
	}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * IuWFNgAj[Vǂ
	 * @return IuWFNgAj[VȂtrue
	 */
	virtual bool isObjectAnimation() const{ return true; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param manager Aj[V}l[W
	 */
	ObjectAnimation(String name, AnimationManager* manager) :
		Animation(name, manager), sequence_(0), time_(0.f){}

	/**
	 * fXgN^
	 */
	virtual ~ObjectAnimation(){}

	//--------------------------------------------------------------------------
	/**
	 * IuWFNgAj[V̒lRs[
	 * @param destination Rs[Ώ
	 */
	virtual void copyObjectAnimationValue(
		ObjectAnimation* destination) const{
		destination->setEnabled(isEnabled());
		destination->setTargetName(getTargetName());
		destination->setSequence(getSequence());
		destination->setTime(getTime());
	}

private:
	// ^[Qbg
	String targetName_;
	// V[PX
	int sequence_;
	// 
	float time_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of OBJECT_ANIMATION_H_
//------------------------------------------------------------------------------
