//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Aj[VZbgwb_
 * @author Junpee
 */

#ifndef ANIMATION_SET_H_
#define ANIMATION_SET_H_

#include <Animation/System/Animation.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * Aj[VZbg
 */
class AnimationSet : public Animation{
friend class AnimationManager;
public:
	//--------------------------------------------------------------------------
	// Aj[VC^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * Aj[V̒ǉ
	 * @param animation ǉAj[V
	 */
	virtual void addAnimation(Animation* animation){
		animations_.add(animation);
	}

	/**
	 * Aj[V̍폜
	 * @param animation 폜Aj[V
	 */
	virtual void removeAnimation(Animation* animation){
		animations_.removeByValue(animation);
	}

	/**
	 * Aj[V̎擾
	 * @return Aj[V
	 */
	virtual int getAnimationCount() const{ return animations_.getCount(); }

	/**
	 * Aj[V̎擾
	 * @param index CfbNX
	 * @return Aj[V
	 */
	virtual Animation* getAnimation(int index) const{
		Assert(index >= 0);
		Assert(index < getAnimationCount());
		return animations_.get(index);
	}

	//--------------------------------------------------------------------------
	// oCh
	//--------------------------------------------------------------------------
	/**
	 * oCh
	 * @param scene oChΏۃV[
	 * @return SẲʃAj[VɃoChtrue
	 */
	virtual bool bind(Scene* scene);

	/**
	 * oCh
	 */
	virtual void unbind();

	//--------------------------------------------------------------------------
	// V[PX
	//--------------------------------------------------------------------------
	/**
	 * V[PX̎擾
	 * @return V[PX
	 */
	virtual int getSequenceCount() const;

	/**
	 * V[PX̐ݒ
	 * @param sequence ݒ肷V[PX
	 * @param time ݒ肷鎞
	 */
	virtual void setSequence(int sequence, float time = 0.f);

	/**
	 * V[PX̎擾
	 * @return V[PX
	 */
	virtual int getSequence() const;

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * Ԃ̐ݒ
	 * @param time ݒ肷鎞
	 */
	virtual void setTime(float time);

	/**
	 * Ԃ̎擾
	 * @return 
	 */
	virtual float getTime() const;

	//--------------------------------------------------------------------------
	// Aj[V
	//--------------------------------------------------------------------------
	/**
	 * Aj[V
	 * @param deltaTime f^^C
	 * @param mask Aj[V}XN
	 * @return Aj[VIĂtrue
	 */
	virtual bool animate(float deltaTime, AnimationMask mask);

	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const;

	/**
	 * IĂ邩
	 * @return IĂtrue
	 */
	virtual bool isFinished() const;

	/**
	 * [vĂ邩
	 * @return [vĂtrue
	 */
	virtual bool isLooped() const;

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param dataCopyMask f[^Rs[}XN
	 * @return Rs[ꂽAj[V
	 */
	virtual Animation* copy(DataCopyMask dataCopyMask = copyNone) const{
		return copyAnimationSet(dataCopyMask);
	}

	/**
	 * Aj[VZbg̃Rs[
	 * @param dataCopyMask f[^Rs[}XN
	 * @return Rs[ꂽAj[V
	 */
	virtual AnimationSet* copyAnimationSet(
		DataCopyMask dataCopyMask = copyNone) const;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * Aj[VZbgǂ
	 * @return Aj[VZbgȂtrue
	 */
	virtual bool isAnimationSet() const{ return true; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param manager Aj[V}l[W
	 */
	AnimationSet(String name, AnimationManager* manager);

	/**
	 * fXgN^
	 */
	virtual ~AnimationSet();

private:
	// Aj[Vz
	ArrayList<Animation*> animations_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of ANIMATION_SET_H_
//------------------------------------------------------------------------------

