//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Aj[V}l[Wwb_
 * @author Junpee
 */

#ifndef ANIMATION_MANAGER_H_
#define ANIMATION_MANAGER_H_

#include <Core/Renamer/Renamer.h>
#include <Core/Container/HashMap.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

class Animation;
class AnimationData;
class AnimationSet;
class CameraAnimation;
class CameraAnimationData;
class SceneNodeAnimation;
class SceneNodeAnimationData;
class CharacterModelAnimation;
class CharacterModelAnimationData;

//------------------------------------------------------------------------------
/**
 * Aj[V}l[W
 */
class AnimationManager : public Renamer::Database{
public:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	AnimationManager();

	/**
	 * fXgN^
	 */
	virtual ~AnimationManager();

	//--------------------------------------------------------------------------
	// Aj[VZbg
	//--------------------------------------------------------------------------
	/**
	 * Aj[VZbg̍쐬
	 *
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param name O
	 * @return Aj[VZbg
	 */
	virtual AnimationSet* createAnimationSet(const String& name);

	//--------------------------------------------------------------------------
	// JAj[V
	//--------------------------------------------------------------------------
	/**
	 * JAj[V̍쐬
	 *
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param name O
	 * @return JAj[V
	 */
	virtual CameraAnimation* createCamera(const String& name);

	/**
	 * JAj[Vf[^̍쐬
	 *
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param name O
	 * @return JAj[Vf[^
	 */
	virtual CameraAnimationData* createCameraData(const String& name);

	//--------------------------------------------------------------------------
	// V[m[hAj[V
	//--------------------------------------------------------------------------
	/**
	 * V[m[hAj[V̍쐬
	 *
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param name O
	 * @return V[m[hAj[V
	 */
	virtual SceneNodeAnimation* createSceneNode(const String& name);

	/**
	 * V[m[hAj[Vf[^̍쐬
	 *
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param name O
	 * @return V[m[hAj[Vf[^
	 */
	virtual SceneNodeAnimationData* createSceneNodeData(const String& name);

	//--------------------------------------------------------------------------
	// fAj[V
	//--------------------------------------------------------------------------
	/**
	 * LN^fAj[V̍쐬
	 *
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param name O
	 * @return LN^fAj[V
	 */
	virtual CharacterModelAnimation* createCharacterModel(
		const String& name);

	/**
	 * LN^fAj[Vf[^̍쐬
	 *
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param name O
	 * @return LN^fAj[Vf[^
	 */
	virtual CharacterModelAnimationData* createCharacterModelData(
		const String& name);

	//--------------------------------------------------------------------------
	// jANA
	//--------------------------------------------------------------------------
	/**
	 * Aj[V̔j
	 *
	 * Aj[VZbg̏ꍇ͊܂܂Aj[Vj܂B
	 * @param animation jAj[V
	 */
	virtual void destroy(Animation* animation);

	/**
	 * Aj[Vf[^̔j
	 * @param animationData jAj[Vf[^
	 * @return t@XJEg
	 */
	virtual int destroyData(AnimationData* animationData);

	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear();

	//--------------------------------------------------------------------------
	// Aj[V
	//--------------------------------------------------------------------------
	/**
	 * Aj[V̎擾
	 * @return Aj[V
	 */
	virtual int getCount(){ return animationArray_.getCount(); }

	/**
	 * Aj[V̎擾
	 * @param index Aj[ṼCfNX
	 * @return Aj[V
	 */
	virtual Animation* get(int index){ return animationArray_.get(index); }

	/**
	 * Aj[V̌
	 * @param name Aj[V
	 * @return Aj[V
	 */
	virtual Animation* search(String name){ return animationHash_.get(name); }

	//--------------------------------------------------------------------------
	// Aj[Vf[^
	//--------------------------------------------------------------------------
	/**
	 * Aj[Vf[^̎擾
	 * @return Aj[Vf[^
	 */
	virtual int getDataCount(){ return animationDataArray_.getCount(); }

	/**
	 * Aj[Vf[^̎擾
	 * @param index Aj[Vf[^̃CfNX
	 * @return Aj[Vf[^
	 */
	virtual AnimationData* getData(int index){
		return animationDataArray_.get(index);
	}

	/**
	 * Aj[Vf[^̌
	 * @param name Aj[Vf[^
	 * @return Aj[Vf[^
	 */
	virtual AnimationData* searchData(String name){
		return animationDataHash_.get(name);
	}

	//--------------------------------------------------------------------------
	// l[֌W
	//--------------------------------------------------------------------------
	/**
	 * Aj[Vl[}̐ݒ
	 * @param renamer ݒ肷Aj[Vl[}
	 */
	virtual void setRenamer(Renamer* renamer);

	/**
	 * Aj[Vl[}̎擾
	 * @return Aj[Vl[}
	 */
	virtual Renamer* getRenamer() const{ return animationRenamer_; }

	/**
	 * Aj[V݂邩ǂ
	 * @param name ݂邩ǂׂ閼O
	 * @return O݂true
	 */
	virtual bool existName(const String& name){
		return (search(name) != NULL);
	}

	/**
	 * Aj[Ṽl[
	 * @param sourceName ƂȂ閼O
	 * @return dĂȂO
	 */
	virtual String rename(String sourceName){
		if(sourceName.getSize() == 0){
			ErrorOut("AnimationManager::rename() name.getSize() == 0");
			sourceName = "invalid";
		}
		if(!existName(sourceName)){ return sourceName; }
		return getRenamer()->rename(this, sourceName);
	}

	//--------------------------------------------------------------------------
	/**
	 * Aj[Vf[^l[}̐ݒ
	 * @param renamer ݒ肷Aj[Vf[^l[}
	 */
	virtual void setDataRenamer(Renamer* renamer);

	/**
	 * Aj[Vf[^l[}̎擾
	 * @return Aj[Vf[^l[}
	 */
	virtual Renamer* getDataRenamer() const{ return animationDataRenamer_; }

	/**
	 * Aj[Vf[^݂邩ǂ
	 * @param name ݂邩ǂׂ閼O
	 * @return O݂true
	 */
	virtual bool existDataName(const String& name){
		return (searchData(name) != NULL);
	}

	/**
	 * Aj[Vf[^̃l[
	 * @param sourceName ƂȂ閼O
	 * @return dĂȂO
	 */
	virtual String renameData(String sourceName){
		if(sourceName.getSize() == 0){
			ErrorOut("AnimationManager::renameData() name.getSize() == 0");
			sourceName = "invalid";
		}
		if(!existDataName(sourceName)){ return sourceName; }
		return getDataRenamer()->rename(this, sourceName);
	}

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	AnimationManager(const AnimationManager& copy);

	// Rs[̉B
	void operator =(const AnimationManager& copy);

	// Aj[VnbV
	HashMap<String, Animation*> animationHash_;
	// Aj[Vz
	ArrayList<Animation*> animationArray_;
	// Aj[Vl[}
	Renamer* animationRenamer_;

	// Aj[Vf[^nbV
	HashMap<String, AnimationData*> animationDataHash_;
	// Aj[Vf[^z
	ArrayList<AnimationData*> animationDataArray_;
	// Aj[Vf[^l[}
	Renamer* animationDataRenamer_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of ANIMATION_MANAGER_H_
//------------------------------------------------------------------------------

