//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Aj[Vf[^wb_
 * @author Junpee
 */

#ifndef ANIMATION_DATA_H_
#define ANIMATION_DATA_H_

namespace Lamp{

class CameraAnimationData;
class SceneNodeAnimationData;
class CharacterModelAnimationData;

//------------------------------------------------------------------------------
/**
 * Aj[Vf[^
 */
class AnimationData{
friend class AnimationManager;
protected:
	//--------------------------------------------------------------------------
	/**
	 * V[PX
	 */
	class Sequence{
	public:
		/**
		 * RXgN^
		 */
		Sequence() : length_(0.f), looped_(false){}

		/**
		* fXgN^
		*/
		virtual ~Sequence(){}

		/**
		 * Rs[
		 * @param copy Rs[
		 */
		virtual void operator =(const Sequence& copy){
			length_ = copy.length_;
			looped_ = copy.looped_;
		}

		/// 
		float length_;
		/// [v
		bool looped_;

	private:
		// Rs[RXgN^̉B
		Sequence(const Sequence& copy);

	};

public:
	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @return Rs[ꂽAj[Vf[^
	 */
	virtual AnimationData* copy() const = 0;

	//--------------------------------------------------------------------------
	// V[PX
	//--------------------------------------------------------------------------
	/**
	 * V[PX̐ݒ
	 * @param sequenceCount V[PX
	 */
	virtual void setSequenceCount(int sequenceCount) = 0;

	/**
	 * V[PX̎擾
	 * @return V[PX
	 */
	virtual int getSequenceCount() const = 0;

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̐ݒ
	 * @param sequence V[PX
	 * @param length 
	 */
	virtual void setLength(int sequence, float length){
		getSequence(sequence)->length_ = length;
	}

	/**
	 * ̎擾
	 * @param sequence V[PX
	 * @return 
	 */
	virtual float getLength(int sequence) const{
		return getSequence(sequence)->length_;
	}

	//--------------------------------------------------------------------------
	// [v
	//--------------------------------------------------------------------------
	/**
	 * [v̐ݒ
	 * @param sequence V[PX
	 * @param looped ݒ肷郋[vtO
	 */
	virtual void setLooped(int sequence, bool looped){
		getSequence(sequence)->looped_ = looped;
	}

	/**
	 * [v̎擾
	 * @param sequence V[PX
	 * @return [vȂtrue
	 */
	virtual bool isLooped(int sequence) const{
		return getSequence(sequence)->looped_;
	}

	//--------------------------------------------------------------------------
	// O
	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual const String& getName() const{ return name_; }

	//--------------------------------------------------------------------------
	// }l[W
	//--------------------------------------------------------------------------
	/**
	 * }l[W̎擾
	 * @return }l[W
	 */
	virtual AnimationManager* getManager() const{ return manager_; }

	//--------------------------------------------------------------------------
	// t@XJE^
	//--------------------------------------------------------------------------
	/**
	 * t@X̒ǉ
	 * @return t@XJEg
	 */
	int addReference(){
		referenceCount_++;
		return referenceCount_;
	}

	/**
	 * t@X̍폜
	 * @return t@XJEg
	 */
	int removeReference(){
		referenceCount_--;
		return referenceCount_;
	}

	/**
	 * t@XJEg̎擾
	 * @return t@XJEg
	 */
	int getReferenceCount() const{ return referenceCount_; }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * JAj[Vf[^ǂ
	 * @return JAj[Vf[^Ȃtrue
	 */
	virtual bool isCameraAnimationData() const{ return false; }

	/**
	 * JAj[Vf[^ւ̃LXg
	 * @return JAj[Vf[^B^ႦNULLԂB
	 */
	virtual CameraAnimationData* castCameraAnimationData() const{
		if(isCameraAnimationData()){ return (CameraAnimationData*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * V[m[hAj[Vf[^ǂ
	 * @return V[m[hAj[Vf[^Ȃtrue
	 */
	virtual bool isSceneNodeAnimationData() const{ return false; }

	/**
	 * V[m[hAj[Vf[^ւ̃LXg
	 * @return V[m[hAj[Vf[^B^ႦNULLԂB
	 */
	virtual SceneNodeAnimationData* castSceneNodeAnimationData() const{
		if(isSceneNodeAnimationData()){ return (SceneNodeAnimationData*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * LN^fAj[Vf[^ǂ
	 * @return LN^fAj[Vf[^Ȃtrue
	 */
	virtual bool isCharacterModelAnimationData() const{ return false; }

	/**
	 * LN^fAj[Vf[^ւ̃LXg
	 * @return LN^fAj[Vf[^B^ႦNULLԂB
	 */
	virtual CharacterModelAnimationData*
		castCharacterModelAnimationData() const{
		if(isCharacterModelAnimationData()){
			return (CharacterModelAnimationData*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param manager Aj[V}l[W
	 */
	AnimationData(const String& name, AnimationManager* manager) :
		name_(name), manager_(manager), referenceCount_(0){}

	/**
	 * fXgN^
	 */
	virtual ~AnimationData(){}

	/**
	 * V[PX̎擾
	 * @param sequence V[PX
	 * @return V[PX
	 */
	virtual Sequence* getSequence(int sequence) = 0;

	/**
	 * V[PX̎擾
	 * @param sequence V[PX
	 * @return V[PX
	 */
	virtual const Sequence* getSequence(int sequence) const = 0;

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	AnimationData(const AnimationData& copy);

	// Rs[̉B
	void operator =(const AnimationData& copy);

	// O
	String name_;
	// Aj[V}l[W
	AnimationManager* manager_;
	// t@XJEg
	int referenceCount_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of ANIMATION_DATA_H_
//------------------------------------------------------------------------------
