//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Aj[Vwb_
 * @author Junpee
 */

#ifndef ANIMATION_H_
#define ANIMATION_H_

namespace Lamp{

class Scene;
class AnimationSet;
class ObjectAnimation;
class CameraAnimation;
class SceneNodeAnimation;
class CharacterModelAnimation;

//------------------------------------------------------------------------------
/**
 * Aj[V
 */
class Animation{
friend class AnimationManager;
public:
	//--------------------------------------------------------------------------
	/// Aj[V}XN
	enum AnimationMask{
		/// JAj[V
		maskCamera =			1 << 0,
		/// V[m[hAj[V
		maskSceneNode =			1 << 1,
		/// LN^fAj[V
		maskCharacterModel =	1 << 2,
		/// JOOAj[V
		maskPreCulling =
			maskCamera |
			maskSceneNode,
		/// JOAj[V
		maskPostCulling =
			maskCharacterModel,
		/// Aj[V
		maskForce =
			maskCamera |
			maskSceneNode |
			maskCharacterModel
	};

	//--------------------------------------------------------------------------
	/// f[^Rs[}XN
	enum DataCopyMask{
		/// f[^Rs[Ȃ
		copyNone =				0,
		/// Jf[^Rs[
		copyCamera =			1 << 0,
		/// V[m[hf[^Rs[
		copySceneNode =			1 << 1,
		/// LN^ff[^Rs[
		copyCharacterModel =	1 << 2,
	};

	//--------------------------------------------------------------------------
	// oCh
	//--------------------------------------------------------------------------
	/**
	 * oCh
	 * @param scene oChΏۃV[
	 * @return true
	 */
	virtual bool bind(Scene* scene) = 0;

	/**
	 * oCh
	 */
	virtual void unbind() = 0;

	//--------------------------------------------------------------------------
	// V[PX
	//--------------------------------------------------------------------------
	/**
	 * V[PX̎擾
	 * @return V[PX
	 */
	virtual int getSequenceCount() const = 0;

	/**
	 * V[PX̐ݒ
	 * @param sequence ݒ肷V[PX
	 * @param time ݒ肷鎞
	 */
	virtual void setSequence(int sequence, float time = 0.f) = 0;

	/**
	 * V[PX̎擾
	 * @return V[PX
	 */
	virtual int getSequence() const = 0;

// ChangeSequenceɂV[PXԁBbŎ̃V[PXɊSڍs邩wB
// Rateɑ΂`ԂxWFԂƂ
	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * Ԃ̐ݒ
	 * @param time ݒ肷鎞
	 */
	virtual void setTime(float time) = 0;

	/**
	 * Ԃ̎擾
	 * @return 
	 */
	virtual float getTime() const = 0;

	//--------------------------------------------------------------------------
	// Aj[V
	//--------------------------------------------------------------------------
	/**
	 * Aj[V
	 * @param deltaTime f^^C
	 * @param mask Aj[V}XN
	 * @return Aj[VIĂtrue
	 */
	virtual bool animate(float deltaTime, AnimationMask mask) = 0;

	/**
	 * IĂ邩
	 * @return IĂtrue
	 */
	virtual bool isFinished() const = 0;

	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const = 0;

	/**
	 * [vĂ邩
	 * @return [vĂtrue
	 */
	virtual bool isLooped() const = 0;

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param dataCopyMask f[^Rs[}XN
	 * @return Rs[ꂽAj[V
	 */
	virtual Animation* copy(DataCopyMask dataCopyMask = copyNone) const = 0;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * Aj[VZbgǂ
	 * @return Aj[VZbgȂtrue
	 */
	virtual bool isAnimationSet() const{ return false; }

	/**
	 * Aj[VZbgւ̃LXg
	 * @return Aj[VZbgB^ႦNULLԂB
	 */
	virtual AnimationSet* castAnimationSet() const{
		if(isAnimationSet()){ return (AnimationSet*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * IuWFNgAj[Vǂ
	 * @return IuWFNgAj[VȂtrue
	 */
	virtual bool isObjectAnimation() const{ return false; }

	/**
	 * IuWFNgAj[Vւ̃LXg
	 * @return IuWFNgAj[VB^ႦNULLԂB
	 */
	virtual ObjectAnimation* castObjectAnimation() const{
		if(isObjectAnimation()){ return (ObjectAnimation*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * JAj[Vǂ
	 * @return JAj[VȂtrue
	 */
	virtual bool isCameraAnimation() const{ return false; }

	/**
	 * JAj[Vւ̃LXg
	 * @return JAj[VB^ႦNULLԂB
	 */
	virtual CameraAnimation* castCameraAnimation() const{
		if(isCameraAnimation()){ return (CameraAnimation*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * V[m[hAj[Vǂ
	 * @return V[m[hAj[VȂtrue
	 */
	virtual bool isSceneNodeAnimation() const{ return false; }

	/**
	 * V[m[hAj[Vւ̃LXg
	 * @return V[m[hAj[VB^ႦNULLԂB
	 */
	virtual SceneNodeAnimation* castSceneNodeAnimation() const{
		if(isSceneNodeAnimation()){ return (SceneNodeAnimation*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * LN^fAj[Vǂ
	 * @return LN^fAj[VȂtrue
	 */
	virtual bool isCharacterModelAnimation() const{ return false; }

	/**
	 * LN^fAj[Vւ̃LXg
	 * @return LN^fAj[VB^ႦNULLԂB
	 */
	virtual CharacterModelAnimation* castCharacterModelAnimation() const{
		if(isCharacterModelAnimation()){
			return (CharacterModelAnimation*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	// O
	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual const String& getName() const{ return name_; }

	//--------------------------------------------------------------------------
	// }l[W
	//--------------------------------------------------------------------------
	/**
	 * }l[W̎擾
	 * @return }l[W
	 */
	virtual AnimationManager* getManager() const{ return manager_; }

	//--------------------------------------------------------------------------
	/**
	 * LA̐ݒ
	 * @param enabled trueȂLAfalseȂ疳
	 */
	virtual void setEnabled(bool enabled){ enabled_ = enabled; }

	/**
	 * LA̎擾
	 * @return trueȂLAfalseȂ疳
	 */
	virtual bool isEnabled() const{ return enabled_; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param manager Aj[V}l[W
	 */
	Animation(String name, AnimationManager* manager) :
		 name_(name), manager_(manager), enabled_(true){}

	/**
	 * fXgN^
	 */
	virtual ~Animation(){}

	/**
	 * Ԃ̑
	 * @param deltaTime f^^C
	 * @return [v␳ꂽ
	 */
	float increasesTime(float deltaTime){
		float time = getTime();
		time += deltaTime;
		setTime(time);
		if(!isLooped()){ return time; }
		return Math::fmod(time, getLength());
	}

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	Animation(const Animation& copy);

	// Rs[̉B
	void operator =(const Animation& copy);

	// O
	String name_;
	// Aj[V}l[W
	AnimationManager* manager_;
	// LAtO
	bool enabled_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of ANIMATION_H_
//------------------------------------------------------------------------------
