//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[m[hAj[Vf[^wb_
 * @author Junpee
 */

#ifndef SCENE_NODE_ANIMATION_DATA_H_
#define SCENE_NODE_ANIMATION_DATA_H_

#include <Animation/System/AnimationData.h>
#include <Animation/VectorInterpolator/VectorInterpolator.h>
#include <Animation/RotationInterpolator/RotationInterpolator.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * V[m[hAj[Vf[^
 */
class SceneNodeAnimationData : public AnimationData{
friend class AnimationManager;
protected:
	//--------------------------------------------------------------------------
	/**
	 * V[m[hV[PX
	 */
	class SceneNodeSequence : public Sequence{
	public:
		/**
		 * RXgN^
		 */
		SceneNodeSequence() : Sequence(),
			scale_(NULL), rotation_(NULL), translation_(NULL){}

		/**
		 * fXgN^
		 */
		virtual ~SceneNodeSequence(){
			SafeDelete(translation_);
			SafeDelete(rotation_);
			SafeDelete(scale_);
		}

		/**
		 * Rs[
		 * @param copy Rs[
		 */
		virtual void operator =(const SceneNodeSequence& copy){
			Sequence::operator=(copy);
			SafeDelete(translation_);
			SafeDelete(rotation_);
			SafeDelete(scale_);
			if(copy.scale_ != NULL){ scale_ = copy.scale_->duplicate(); }
			if(copy.rotation_ != NULL){
				rotation_ = copy.rotation_->duplicate();
			}
			if(copy.translation_ != NULL){
				translation_ = copy.translation_->duplicate();
			}
		}

		/**
		 * ̌vZ
		 */
		virtual void calcLength(){
			length_ = 0.f;
			if((scale_ != NULL) && (scale_->getLength() > length_)){
				length_ = scale_->getLength();
			}
			if((rotation_ != NULL) && (rotation_->getLength() > length_)){
				length_ = rotation_->getLength();
			}
			if((translation_ != NULL) &&
				(translation_->getLength() > length_)){
				length_ = translation_->getLength();
			}
		}

		/// XP[
		VectorInterpolator* scale_;
		/// ]
		RotationInterpolator* rotation_;
		/// ړ
		VectorInterpolator* translation_;

	};

public:
	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @return Rs[ꂽAj[Vf[^
	 */
	virtual AnimationData* copy() const{ return copySceneNodeAnimationData(); }

	/**
	 * V[m[hAj[Vf[^̃Rs[
	 */
	virtual SceneNodeAnimationData* copySceneNodeAnimationData() const;

	//--------------------------------------------------------------------------
	// V[PX
	//--------------------------------------------------------------------------
	/**
	 * V[PX̐ݒ
	 * @param sequenceCount V[PX
	 */
	virtual void setSequenceCount(int sequenceCount){
		SafeArrayDelete(sequences_);
		sequenceCount_ = sequenceCount;
		if(sequenceCount_ == 0){ return; }
		sequences_ = new SceneNodeSequence[sequenceCount_];
	}

	/**
	 * V[PX̎擾
	 * @return V[PX
	 */
	virtual int getSequenceCount() const{ return sequenceCount_; }

	//--------------------------------------------------------------------------
	// XP[
	//--------------------------------------------------------------------------
	/**
	 * XP[̐ݒ
	 * @param sequence V[PX
	 * @param scale ݒ肷XP[
	 */
	virtual void setScale(int sequence, VectorInterpolator* scale){
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		SceneNodeSequence& data = sequences_[sequence];
		SafeDelete(data.scale_);
		data.scale_ = scale;
		data.calcLength();
	}

	/**
	 * XP[̎擾
	 * @param sequence V[PX
	 * @return XP[
	 */
	virtual VectorInterpolator* getScale(int sequence) const{
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return sequences_[sequence].scale_;
	}

	//--------------------------------------------------------------------------
	// ]
	//--------------------------------------------------------------------------
	/**
	 * ]̐ݒ
	 * @param sequence V[PX
	 * @param rotation ݒ肷]
	 */
	virtual void setRotation(int sequence, RotationInterpolator* rotation){
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		SceneNodeSequence& data = sequences_[sequence];
		SafeDelete(data.rotation_);
		data.rotation_ = rotation;
		data.calcLength();
	}

	/**
	 * ]̎擾
	 * @param sequence V[PX
	 * @return ]
	 */
	virtual RotationInterpolator* getRotation(int sequence) const{
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return sequences_[sequence].rotation_;
	}

	//--------------------------------------------------------------------------
	// ړ
	//--------------------------------------------------------------------------
	/**
	 * ړ̐ݒ
	 * @param sequence V[PX
	 * @param translation ݒ肷ړ
	 */
	virtual void setTranslation(
		int sequence, VectorInterpolator* translation){
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		SceneNodeSequence& data = sequences_[sequence];
		SafeDelete(data.translation_);
		data.translation_ = translation;
		data.calcLength();
	}

	/**
	 * ړ̎擾
	 * @param sequence V[PX
	 * @return ړ
	 */
	virtual VectorInterpolator* getTranslation(int sequence) const{
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return sequences_[sequence].translation_;
	}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * V[m[hAj[Vf[^ǂ
	 * @return V[m[hAj[Vf[^Ȃtrue
	 */
	virtual bool isSceneNodeAnimationData() const{ return true; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param manager Aj[V}l[W
	 */
	SceneNodeAnimationData(const String& name, AnimationManager* manager) :
		AnimationData(name, manager), sequenceCount_(0), sequences_(NULL){
	}

	/**
	 * fXgN^
	 */
	virtual ~SceneNodeAnimationData(){
		SafeArrayDelete(sequences_);
	}

	//--------------------------------------------------------------------------
	/**
	 * V[PX̎擾
	 * @param sequence V[PX
	 * @return V[PX
	 */
	virtual Sequence* getSequence(int sequence){
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return &sequences_[sequence];
	}

	/**
	 * V[PX̎擾
	 * @param sequence V[PX
	 * @return V[PX
	 */
	virtual const Sequence* getSequence(int sequence) const{
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return &sequences_[sequence];
	}

	//--------------------------------------------------------------------------
private:
	// V[PX
	int sequenceCount_;
	// V[PX
	SceneNodeSequence* sequences_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SCENE_NODE_ANIMATION_DATA_H_
//------------------------------------------------------------------------------
