//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[m[hAj[Vwb_
 * @author Junpee
 */

#ifndef SCENE_NODE_ANIMATION_H_
#define SCENE_NODE_ANIMATION_H_

#include <Animation/System/ObjectAnimation.h>
#include <Animation/SceneNode/SceneNodeAnimationData.h>

namespace Lamp{

class SceneNode;

//------------------------------------------------------------------------------
/**
 * V[m[hAj[V
 */
class SceneNodeAnimation : public ObjectAnimation{
friend class AnimationManager;
public:
	//--------------------------------------------------------------------------
	// Aj[Vf[^
	//--------------------------------------------------------------------------
	/**
	 * Aj[Vf[^̎擾
	 * @return Aj[Vf[^
	 */
	virtual AnimationData* getAnimationData(){ return animationData_; }

	/**
	 * Aj[Vf[^̎擾
	 * @return Aj[Vf[^
	 */
	virtual const AnimationData* getAnimationData() const{
		return animationData_;
	}

	//--------------------------------------------------------------------------
	// V[m[hAj[Vf[^
	//--------------------------------------------------------------------------
	/**
	 * V[m[hAj[Vf[^̐ݒ
	 * @param animationData V[m[hAj[Vf[^
	 */
	virtual void setSceneNodeAnimationData(
		SceneNodeAnimationData* animationData){
		if(animationData_ != NULL){ animationData_->removeReference(); }
		animationData_ = animationData;
		if(animationData_ != NULL){ animationData_->addReference(); }
	}

	/**
	 * V[m[hAj[Vf[^̎擾
	 * @return V[m[hAj[Vf[^
	 */
	virtual SceneNodeAnimationData* getSceneNodeAnimationData(){
		return animationData_;
	}

	/**
	 * V[m[hAj[Vf[^̎擾
	 * @return V[m[hAj[Vf[^
	 */
	virtual const SceneNodeAnimationData* getSceneNodeAnimationData() const{
		return animationData_;
	}

	//--------------------------------------------------------------------------
	// oCh
	//--------------------------------------------------------------------------
	/**
	 * oCh
	 * @param scene oChΏۃV[
	 * @return true
	 */
	virtual bool bind(Scene* scene);

	/**
	 * oCh
	 * @param sceneNode oChΏۃV[m[h
	 * @return true
	 */
	virtual bool bind(SceneNode* sceneNode);

	/**
	 * oCh
	 */
	virtual void unbind(){ target_ = NULL; }

	/**
	 * ^[Qbg̎擾
	 * @return ^[Qbg
	 */
	virtual SceneNode* getTarget() const{ return target_; }

	//--------------------------------------------------------------------------
	// Aj[V
	//--------------------------------------------------------------------------
	/**
	 * Aj[V
	 * @param deltaTime f^^C
	 * @param mask Aj[V}XN
	 * @return Aj[VIĂtrue
	 */
	virtual bool animate(float deltaTime, AnimationMask mask);

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param dataCopyMask f[^Rs[}XN
	 * @return Rs[ꂽAj[V
	 */
	virtual Animation* copy(DataCopyMask dataCopyMask = copyNone) const{
		return copySceneNodeAnimation(dataCopyMask);
	}

	/**
	 * V[m[hAj[ṼRs[
	 * @param dataCopyMask f[^Rs[}XN
	 * @return Rs[ꂽAj[V
	 */
	virtual SceneNodeAnimation* copySceneNodeAnimation(
		DataCopyMask dataCopyMask = copyNone) const;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * V[m[hAj[Vǂ
	 * @return V[m[hAj[VȂtrue
	 */
	virtual bool isSceneNodeAnimation() const{ return true; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param manager Aj[V}l[W
	 */
	SceneNodeAnimation(String name, AnimationManager* manager);

	/**
	 * fXgN^
	 */
	virtual ~SceneNodeAnimation();

private:
	// Aj[Vf[^
	SceneNodeAnimationData* animationData_;
	// ^[Qbg
	SceneNode* target_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SCENE_NODE_ANIMATION_H_
//------------------------------------------------------------------------------

