//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ]ԃwb_
 * @author Junpee
 */

#ifndef ROTATION_INTERPOLATOR_H_
#define ROTATION_INTERPOLATOR_H_

namespace Lamp{

class RotationConstantInterpolator;
class EulerArrayInterpolator;
class QuaternionArrayInterpolator;
class QuaternionLinearInterpolator;

//------------------------------------------------------------------------------
/**
 * ]
 *
 * TuNXŃRs[RXgN^ƑZq
 */
class RotationInterpolator{
public:
	//--------------------------------------------------------------------------
	/**
	 * fXgN^
	 */
	virtual ~RotationInterpolator(){}

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ꂽ]ԁBĂяodeleteKv
	 */
	virtual RotationInterpolator* duplicate() const = 0;

	/**
	 * lǂ
	 * @param target rΏ
	 * @return lȂtrue
	 */
	virtual bool equals(const RotationInterpolator& target) const = 0;

	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const = 0;

	//--------------------------------------------------------------------------
	// IC[
	//--------------------------------------------------------------------------
	/**
	 * IC[Ԃǂ
	 * @return IC[ԂȂtrue
	 */
	virtual bool isEulerInterpolator() const = 0;

	/**
	 * IC[
	 * @param time 
	 * @return Ԃꂽ]
	 */
	virtual Vector3 eulerInterpolate(float time) = 0;

	//--------------------------------------------------------------------------
	// NH[^jI
	//--------------------------------------------------------------------------
	/**
	 * NH[^jIԂǂ
	 * @return NH[^jIԂȂtrue
	 */
	virtual bool isQuaternionInterpolator() const = 0;

	/**
	 * NH[^jI
	 * @param time 
	 * @return Ԃꂽ]
	 */
	virtual Quaternion quaternionInterpolate(float time) = 0;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * ]萔Ԃǂ
	 * @return ]萔ԂȂtrue
	 */
	virtual bool isRotationConstantInterpolator() const{ return false; }

	/**
	 * ]萔Ԃւ̃LXg
	 * @return ]萔ԁB^ႦNULLԂB
	 */
	virtual RotationConstantInterpolator*
		castRotationConstantInterpolator() const{
		if(isRotationConstantInterpolator()){
			return (RotationConstantInterpolator*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * IC[]zԂǂ
	 * @return IC[]zԂȂtrue
	 */
	virtual bool isEulerArrayInterpolator() const{ return false; }

	/**
	 * IC[]zԂւ̃LXg
	 * @return IC[]zԁB^ႦNULLԂB
	 */
	virtual EulerArrayInterpolator*
		castEulerArrayInterpolator() const{
		if(isEulerArrayInterpolator()){
			return (EulerArrayInterpolator*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * l]zԂǂ
	 * @return l]zԂȂtrue
	 */
	virtual bool isQuaternionArrayInterpolator() const{ return false; }

	/**
	 * l]zԂւ̃LXg
	 * @return l]zԁB^ႦNULLԂB
	 */
	virtual QuaternionArrayInterpolator*
		castQuaternionArrayInterpolator() const{
		if(isQuaternionArrayInterpolator()){
			return (QuaternionArrayInterpolator*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * l]`Ԃǂ
	 * @return l]`ԂȂtrue
	 */
	virtual bool isQuaternionLinearInterpolator() const{ return false; }

	/**
	 * l]`Ԃւ̃LXg
	 * @return l]`ԁB^ႦNULLԂB
	 */
	virtual QuaternionLinearInterpolator*
		castQuaternionLinearInterpolator() const{
		if(isQuaternionLinearInterpolator()){
			return (QuaternionLinearInterpolator*)this;
		}
		return NULL;
	}

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of ROTATION_INTERPOLATOR_H_
//------------------------------------------------------------------------------

