//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ]Ԉkwb_
 * @author Junpee
 */

#ifndef ROTATION_INTERPOLATION_COMPRESSOR_H_
#define ROTATION_INTERPOLATION_COMPRESSOR_H_

namespace Lamp{

class RotationInterpolator;
class EulerArrayInterpolator;
class QuaternionArrayInterpolator;

//------------------------------------------------------------------------------
/**
 * ]Ԉk
 */
class RotationInterpolationCompressor{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	RotationInterpolationCompressor();

	/**
	 * fXgN^
	 */
	virtual ~RotationInterpolationCompressor();

	//--------------------------------------------------------------------------
	// k
	//--------------------------------------------------------------------------
	/**
	 * k
	 * @param source ksIC[]z
	 * @param tolerance e덷̊pxWAŎw肷
	 * @return ks]
	 */
	virtual RotationInterpolator* compress(
		EulerArrayInterpolator* source, float tolerance);

	//--------------------------------------------------------------------------
	/**
	 * k
	 * @param source ksl]z
	 * @param tolerance e덷̊pxWAŎw肷
	 * @return ks]
	 */
	virtual RotationInterpolator* compress(
		QuaternionArrayInterpolator* source, float tolerance);

	//--------------------------------------------------------------------------
	// k
	//--------------------------------------------------------------------------
	/**
	 * e덷̎擾
	 * @return e덷
	 */
	virtual float getTolerance() const{ return tolerance_; }

	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const{ return length_; }

	//--------------------------------------------------------------------------
	/**
	 * \[XL[̎擾
	 * @return \[XL[
	 */
	virtual int getSourceKeyCount() const{ return sourceKeyCount_; }

	/**
	 * \[XTCY̎擾
	 * @return \[XTCY
	 */
	virtual int getSourceSize() const{
		return getSourceKeyCount() * sourceKeySize_;
	}

	//--------------------------------------------------------------------------
	/**
	 * kL[̎擾
	 * @return kL[
	 */
	virtual int getCompressedKeyCount() const{ return compressedKeyCount_; }

	/**
	 * kTCY̎擾
	 * @return kTCY
	 */
	virtual int getCompressedSize() const{
		return getCompressedKeyCount() * compressedKeySize_;
	}

	//--------------------------------------------------------------------------
	/**
	 * k̎擾
	 * @return k
	 */
	virtual float getCompressionRate() const{
		if(getSourceSize() == 0){ return 0.f; }
		return (float)getCompressedSize() / (float)getSourceSize();
	}

	/**
	 * ʕ̎擾
	 * @return ʕ
	 */
	virtual String getResultString() const;

protected:
	//--------------------------------------------------------------------------
	/// `L[
	class LinearKey{
	friend class RotationInterpolationCompressor;
	private:
		/// l
		Quaternion value_;
		/// 
		float time_;
		/// ő덷̃RTC
		float errorCos_;
	};

	//--------------------------------------------------------------------------
	// k
	//--------------------------------------------------------------------------
	/**
	 * k
	 * @param source ksl]z
	 * @param tolerance e덷
	 */
	virtual void compressSetup(
		QuaternionArrayInterpolator* source, float tolerance);

	/**
	 * 萔k
	 * @param source ksl]z
	 * @return kʁAsȂNULL
	 */
	virtual RotationInterpolator* compressConstant(
		QuaternionArrayInterpolator* source);

	/**
	 * `k
	 * @param source ksl]z
	 * @return kʁAsȂNULL
	 */
	virtual RotationInterpolator* compressLinear(
		QuaternionArrayInterpolator* source);

	/**
	 * `k덷̍ČvZ
	 * @param source ksl]z
	 * @param preKey ÕL[
	 * @param key ČvZL[
	 * @param postKey ̃L[
	 */
	virtual void recalcLinearError(QuaternionArrayInterpolator* source,
		LinearKey& preKey, LinearKey& key, LinearKey& postKey);

	/**
	 * kʂ̐ݒ
	 * @param compressedKeyCount kL[
	 * @param compressedKeySize kL[TCY
	 */
	virtual void setCompressedData(
		int compressedKeyCount, int compressedKeySize){
		compressedKeyCount_ = compressedKeyCount;
		compressedKeySize_ = compressedKeySize;
	}

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	/// \[XL[TCY
	static const int sourceKeySize_ = sizeof(Quaternion);

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	RotationInterpolationCompressor(const RotationInterpolationCompressor& copy);

	// Rs[̉B
	void operator =(const RotationInterpolationCompressor& copy);

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	// e덷
	float tolerance_;
	// 
	float length_;
	// \[XL[
	int sourceKeyCount_;
	// kL[
	int compressedKeyCount_;
	// kL[TCY
	int compressedKeySize_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of ROTATION_INTERPOLATION_COMPRESSOR_H_
//------------------------------------------------------------------------------

