//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ]萔ԃwb_
 * @author Junpee
 */

#ifndef ROTATION_CONSTANT_INTERPOLATOR_H_
#define ROTATION_CONSTANT_INTERPOLATOR_H_

#include <Animation/RotationInterpolator/RotationInterpolator.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ]萔
 */
class RotationConstantInterpolator : public RotationInterpolator{
public:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	RotationConstantInterpolator() : euler_(Vector3::zero),
		quaternion_(Quaternion::identity), length_(0.f){}

	/**
	 * fXgN^
	 */
	virtual ~RotationConstantInterpolator(){}

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ꂽ]ԁBĂяodeleteKv
	 */
	virtual RotationInterpolator* duplicate() const{
		RotationInterpolator* result = new RotationConstantInterpolator(*this);
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target rΏ
	 * @return lȂtrue
	 */
	virtual bool equals(const RotationInterpolator& target) const{
		RotationConstantInterpolator* interpolator =
			target.castRotationConstantInterpolator();
		if(interpolator == NULL){ return false; }
		return ((euler_ == interpolator->euler_) &&
			(quaternion_ == interpolator->quaternion_) &&
			(length_ == interpolator->length_));
	}

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̐ݒ
	 * @param length 
	 */
	virtual void setLength(float length){
		Assert(length >= 0.f);
		length_ = length;
	}

	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const{ return length_; }

	//--------------------------------------------------------------------------
	// IC[
	//--------------------------------------------------------------------------
	/**
	 * IC[Ԃǂ
	 * @return IC[ԂȂtrue
	 */
	virtual bool isEulerInterpolator() const{ return true; }

	/**
	 * IC[
	 * @param time 
	 * @return Ԃꂽ]
	 */
	virtual Vector3 eulerInterpolate(float time){ return euler_; }

	//--------------------------------------------------------------------------
	// l
	//--------------------------------------------------------------------------
	/**
	 * lԂǂ
	 * @return lԂȂtrue
	 */
	virtual bool isQuaternionInterpolator() const{ return true; }

	/**
	 * l
	 * @param time 
	 * @return Ԃꂽ]
	 */
	virtual Quaternion quaternionInterpolate(float time){ return quaternion_; }

	//--------------------------------------------------------------------------
	// l
	//--------------------------------------------------------------------------
	/**
	 * XYZ]̐ݒ
	 * @param euler ݒ肷XYZ]
	 */
	virtual void setEuler(const Vector3& euler){
		euler_ = euler;
		quaternion_.setRotationXYZ(euler_);
	}

	/**
	 * XYZ]̎擾
	 * @return 擾XYZ]
	 */
	virtual Vector3 getEuler(){ return euler_; }

	//--------------------------------------------------------------------------
	/**
	 * l]̐ݒ
	 * @param quaternion ݒ肷l]
	 */
	virtual void setQuaternion(const Quaternion& quaternion){
		quaternion_ = quaternion;
		quaternion_.getRotationXYZ(&euler_);
	}

	/**
	 * l]̎擾
	 * @return 擾l]
	 */
	virtual Quaternion getQuaternion(){ return quaternion_; }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * ]萔Ԃǂ
	 * @return ]萔ԂȂtrue
	 */
	virtual bool isRotationConstantInterpolator() const{ return true; }

	//--------------------------------------------------------------------------
private:
	// IC[
	Vector3 euler_;
	// l
	Quaternion quaternion_;
	// 
	float length_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of ROTATION_CONSTANT_INTERPOLATOR_H_
//------------------------------------------------------------------------------

