//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * l]`ԃwb_
 * @author Junpee
 */

#ifndef QUATERNION_LINEAR_INTERPOLATOR_H_
#define QUATERNION_LINEAR_INTERPOLATOR_H_

#include <Animation/RotationInterpolator/RotationInterpolator.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * l]`
 */
class QuaternionLinearInterpolator : public RotationInterpolator{
public:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	QuaternionLinearInterpolator();

	/**
	 * fXgN^
	 */
	virtual ~QuaternionLinearInterpolator();

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	explicit QuaternionLinearInterpolator(
		const QuaternionLinearInterpolator& copy);

	/**
	 * Zq
	 * @param copy 
	 */
	virtual QuaternionLinearInterpolator& operator =(
		const QuaternionLinearInterpolator& copy);

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ꂽxNgԁBĂяodeleteKv
	 */
	virtual RotationInterpolator* duplicate() const{
		RotationInterpolator* result = new QuaternionLinearInterpolator(*this);
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target rΏ
	 * @return lȂtrue
	 */
	virtual bool equals(const RotationInterpolator& target) const{
		QuaternionLinearInterpolator* interpolator =
			target.castQuaternionLinearInterpolator();
		if(interpolator == NULL){ return false; }
		if(keyCount_ != interpolator->keyCount_){ return false; }
		for(int i = 0; i < keyCount_; i++){
			const Key& key = keys_[i];
			const Key& targetKey = interpolator->keys_[i];
			if(key.value_ != targetKey.value_){ return false; }
			if(key.time_ != targetKey.time_){ return false; }
		}
		return true;
	}

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const;

	//--------------------------------------------------------------------------
	// IC[
	//--------------------------------------------------------------------------
	/**
	 * IC[Ԃǂ
	 * @return IC[ԂȂtrue
	 */
	virtual bool isEulerInterpolator() const{ return true; }

	/**
	 * IC[
	 * @param time 
	 * @return Ԃꂽ]
	 */
	virtual Vector3 eulerInterpolate(float time);

	//--------------------------------------------------------------------------
	// l
	//--------------------------------------------------------------------------
	/**
	 * lԂǂ
	 * @return lԂȂtrue
	 */
	virtual bool isQuaternionInterpolator() const{ return true; }

	/**
	 * l
	 * @param time 
	 * @return Ԃꂽ]
	 */
	virtual Quaternion quaternionInterpolate(float time);

	//--------------------------------------------------------------------------
	// L[
	//--------------------------------------------------------------------------
	/**
	 * L[̐ݒ
	 * @param keyCount L[
	 */
	virtual void setKeyCount(int keyCount);

	/**
	 * L[̎擾
	 * @return L[
	 */
	virtual int getKeyCount() const{ return keyCount_; }

	//--------------------------------------------------------------------------
	/**
	 * L[̐ݒ
	 * @param index L[CfbNX
	 * @param time 
	 * @param value l
	 */
	virtual void setKey(int index, float time, const Quaternion& value){
		Assert((index >= 0) && (index < keyCount_) && (keys_ != NULL));
		Key& key = keys_[index];
		key.value_ = value;
		key.time_ = time;
	}

	/**
	 * l̎擾
	 * @param index L[CfbNX
	 * @return l
	 */
	virtual const Quaternion& getValue(int index) const{
		Assert((index >= 0) && (index < keyCount_) && (keys_ != NULL));
		return keys_[index].value_;
	}

	/**
	 * Ԃ̎擾
	 * @param index L[CfbNX
	 * @return 
	 */
	virtual float getTime(int index) const{
		Assert((index >= 0) && (index < keyCount_) && (keys_ != NULL));
		return keys_[index].time_;
	}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * l]`Ԃǂ
	 * @return l]`ԂȂtrue
	 */
	virtual bool isQuaternionLinearInterpolator() const{ return true; }

	//--------------------------------------------------------------------------
private:
	/// L[
	class Key{
	friend class QuaternionLinearInterpolator;
	private:
		/// l
		Quaternion value_;
		/// 
		float time_;
	};

	// L[
	Key* keys_;
	// L[̐
	int keyCount_;
	// ŌɎgpL[CfbNX
	int lastestUseKeyIndex_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of QUATERNION_LINEAR_INTERPOLATOR_H_
//------------------------------------------------------------------------------
