//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * l]zԃwb_
 * @author Junpee
 */

#ifndef QUATERNION_ARRAY_INTERPOLATOR_H_
#define QUATERNION_ARRAY_INTERPOLATOR_H_

#include <Animation/RotationInterpolator/RotationInterpolator.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * l]z
 */
class QuaternionArrayInterpolator : public RotationInterpolator{
public:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	QuaternionArrayInterpolator();

	/**
	 * fXgN^
	 */
	virtual ~QuaternionArrayInterpolator();

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	explicit QuaternionArrayInterpolator(
		const QuaternionArrayInterpolator& copy);

	/**
	 * Zq
	 * @param copy 
	 */
	virtual QuaternionArrayInterpolator& operator =(
		const QuaternionArrayInterpolator& copy);

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ꂽIC[]ԁBĂяodeleteKv
	 */
	virtual RotationInterpolator* duplicate() const{
		RotationInterpolator* result =
			new QuaternionArrayInterpolator(*this);
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target rΏ
	 * @return lȂtrue
	 */
	virtual bool equals(const RotationInterpolator& target) const{
		QuaternionArrayInterpolator* interpolator =
			target.castQuaternionArrayInterpolator();
		if(interpolator == NULL){ return false; }
		if(size_ != interpolator->size_){ return false; }
		for(int i = 0; i < size_; i++){
			if(array_[i] != interpolator->array_[i]){ return false; }
		}
		return true;
	}

	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const{ return length_; }

	//--------------------------------------------------------------------------
	// IC[
	//--------------------------------------------------------------------------
	/**
	 * IC[Ԃǂ
	 * @return IC[ԂȂtrue
	 */
	virtual bool isEulerInterpolator() const{ return true; }

	/**
	 * IC[
	 * @param time 
	 * @return Ԃꂽ]
	 */
	virtual Vector3 eulerInterpolate(float time);

	//--------------------------------------------------------------------------
	// l
	//--------------------------------------------------------------------------
	/**
	 * lԂǂ
	 * @return lԂȂtrue
	 */
	virtual bool isQuaternionInterpolator() const{ return true; }

	/**
	 * l
	 * @param time 
	 * @return Ԃꂽ]
	 */
	virtual Quaternion quaternionInterpolate(float time);

	//--------------------------------------------------------------------------
	// l
	//--------------------------------------------------------------------------
	/**
	 * TCYݒ
	 * @param size ݒ肷TCYBTCY - 1LengthɂȂB
	 */
	virtual void setSize(int size);

	/**
	 * TCY擾
	 * @return TCY
	 */
	virtual int getSize() const{ return size_; }

	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param index ݒ肷l̃CfbNX
	 * @param value ݒ肷l
	 */
	virtual void setValue(int index, const Quaternion& value);

	/**
	 * l̕␳
	 */
	virtual void correctValue();

	/**
	 * l̎擾
	 * @param index 擾l̃CfbNX
	 * @return l
	 */
	virtual const Quaternion& getValue(int index) const{
		Assert(array_ != NULL);
		Assert(index >= 0);
		Assert(index < size_);
		return array_[index];
	}

	//--------------------------------------------------------------------------
	// ϊ
	//--------------------------------------------------------------------------
	/**
	 * IC[]zԂւ̕ϊ
	 * @return IC[]zԁAĂяoŔjKv
	 */
	EulerArrayInterpolator* convertEulerArrayInterpolator() const;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * l]zԂǂ
	 * @return l]zԂȂtrue
	 */
	virtual bool isQuaternionArrayInterpolator() const{ return true; }

	//--------------------------------------------------------------------------
private:
	// z
	Quaternion* array_;
	// TCY
	int size_;
	// 
	float length_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of QUATERNION_ARRAY_INTERPOLATOR_H_
//------------------------------------------------------------------------------

