//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * LN^fAj[Vwb_
 * @author Junpee
 */

#ifndef CHARACTER_MODEL_ANIMATION_H_
#define CHARACTER_MODEL_ANIMATION_H_

#include <Animation/System/ObjectAnimation.h>
#include <Animation/Model/CharacterModelAnimationData.h>

namespace Lamp{

class CharacterModel;
class Bone;

//------------------------------------------------------------------------------
/**
 * LN^fAj[V
 */
class CharacterModelAnimation : public ObjectAnimation{
friend class AnimationManager;
public:
	//--------------------------------------------------------------------------
	// Aj[Vf[^
	//--------------------------------------------------------------------------
	/**
	 * Aj[Vf[^̎擾
	 * @return Aj[Vf[^
	 */
	virtual AnimationData* getAnimationData(){ return animationData_; }

	/**
	 * Aj[Vf[^̎擾
	 * @return Aj[Vf[^
	 */
	virtual const AnimationData* getAnimationData() const{
		return animationData_;
	}

	//--------------------------------------------------------------------------
	// LN^fAj[Vf[^
	//--------------------------------------------------------------------------
	/**
	 * LN^fAj[Vf[^̐ݒ
	 * @param animationData LN^fAj[Vf[^
	 */
	virtual void setCharacterModelAnimationData(
		CharacterModelAnimationData* animationData){
		if(animationData_ != NULL){ animationData_->removeReference(); }
		animationData_ = animationData;
		if(animationData_ != NULL){ animationData_->addReference(); }
	}

	/**
	 * LN^fAj[Vf[^̎擾
	 */
	virtual CharacterModelAnimationData* getCharacterModelAnimationData(){
		return animationData_;
	}

	/**
	 * LN^fAj[Vf[^̎擾
	 */
	virtual const CharacterModelAnimationData*
		getCharacterModelAnimationData() const{
		return animationData_;
	}

	//--------------------------------------------------------------------------
	// oCh
	//--------------------------------------------------------------------------
	/**
	 * oCh
	 * @param scene oChΏۃV[
	 * @return true
	 */
	virtual bool bind(Scene* scene);

	/**
	 * oCh
	 * @param model oChΏۃLN^f
	 * @return true
	 */
	virtual bool bind(CharacterModel* model);

	/**
	 * oCh
	 */
	virtual void unbind(){
		target_ = NULL;
		for(int i = 0; i < boneCount_; i++){ targetBones_[i] = NULL; }
	}

	/**
	 * ^[Qbg̎擾
	 * @return ^[Qbg
	 */
	virtual CharacterModel* getTarget() const{ return target_; }

	/**
	 * ^[Qbg{[̎擾
	 * @param index ^[Qbg{[̃CfbNX
	 */
	virtual Bone* getTargetBone(int index) const{
		Assert(index >= 0);
		Assert(index < boneCount_);
		return targetBones_[index];
	}

	//--------------------------------------------------------------------------
	// {[
	//--------------------------------------------------------------------------
	/**
	 * {[̐ݒ
	 * @param boneCount {[
	 */
	virtual void setBoneCount(int boneCount){
		boneCount_ = boneCount;
		SafeArrayDelete(targetBones_);
		SafeArrayDelete(boneNames_);
		if(boneCount_ != 0){
			boneNames_ = new String[boneCount_];
			targetBones_ = new Bone*[boneCount_];
			for(int i = 0; i < boneCount_; i++){ targetBones_[i] = NULL; }
		}
	}

	/**
	 * {[̎擾
	 * @return {[
	 */
	virtual int getBoneCount() const{ return boneCount_; }

	//--------------------------------------------------------------------------
	/**
	 * {[̐ݒ
	 * @param index {[̃CfbNX
	 * @param boneName {[
	 */
	virtual void setBoneName(int index, const String& boneName){
		Assert(index >= 0);
		Assert(index < boneCount_);
		boneNames_[index] = boneName;
	}

	/**
	 * {[̎擾
	 * @param index {[̃CfbNX
	 * @return {[
	 */
	virtual const String& getBoneName(int index) const{
		Assert(index >= 0);
		Assert(index < boneCount_);
		return boneNames_[index];
	}

	//--------------------------------------------------------------------------
	// Aj[V
	//--------------------------------------------------------------------------
	/**
	 * Aj[V
	 * @param deltaTime f^^C
	 * @param mask Aj[V}XN
	 * @return Aj[VIĂtrue
	 */
	virtual bool animate(float deltaTime, AnimationMask mask);

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param dataCopyMask f[^Rs[}XN
	 * @return Rs[ꂽAj[V
	 */
	virtual Animation* copy(DataCopyMask dataCopyMask = copyNone) const{
		return copyCharacterModelAnimation(dataCopyMask);
	}

	/**
	 * LN^fAj[ṼRs[
	 * @param dataCopyMask f[^Rs[}XN
	 * @return Rs[ꂽAj[V
	 */
	virtual CharacterModelAnimation* copyCharacterModelAnimation(
		DataCopyMask dataCopyMask = copyNone) const;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * LN^fAj[Vǂ
	 * @return LN^fAj[VȂtrue
	 */
	virtual bool isCharacterModelAnimation() const{ return true; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param manager Aj[V}l[W
	 */
	CharacterModelAnimation(String name, AnimationManager* manager);

	/**
	 * fXgN^
	 */
	virtual ~CharacterModelAnimation();

private:
	// Aj[Vf[^
	CharacterModelAnimationData* animationData_;
	// ^[Qbg
	CharacterModel* target_;
	// {[
	int boneCount_;
	// {[
	String* boneNames_;
	// ^[Qbg{[
	Bone** targetBones_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of CHARACTER_MODEL_ANIMATION_H_
//------------------------------------------------------------------------------

