//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgAj[VZ[owb_
 * @author Junpee
 */

#ifndef TEXT_ANIMATION_SAVER_H_
#define TEXT_ANIMATION_SAVER_H_

namespace Lamp{

class TextWriter;
class AnimationManager;
class VectorInterpolator;
class VectorConstantInterpolator;
class VectorArrayInterpolator;
class VectorLinearInterpolator;
class RotationInterpolator;
class RotationConstantInterpolator;
class EulerArrayInterpolator;
class QuaternionArrayInterpolator;
class QuaternionLinearInterpolator;
class AnimationSet;
class CameraAnimation;
class CameraAnimationData;
class SceneNodeAnimation;
class SceneNodeAnimationData;
class CharacterModelAnimation;
class CharacterModelAnimationData;

//------------------------------------------------------------------------------
/**
 * eLXgAj[VZ[o
 */
class TextAnimationSaver{
public:
	/**
	 * RXgN^
	 */
	TextAnimationSaver();

	/**
	 * fXgN^
	 */
	virtual ~TextAnimationSaver();

	/**
	 * Z[u
	 * @param filePath t@CpX
	 * @param manager Z[uAj[V}l[W
	 */
	virtual void save(const String& filePath, AnimationManager* manager);

	/**
	 * Z[u
	 * @param textWriter eLXgC^
	 * @param manager Z[uAj[V}l[W
	 */
	virtual void save(TextWriter* textWriter, AnimationManager* manager);

protected:
	/**
	 * wb_̏o
	 */
	virtual void writeHeader();

	/**
	 * IuWFNg̃JEg
	 * @return IuWFNg
	 */
	virtual int countObjects();

	/**
	 * Aj[VXg̏o
	 */
	virtual void writeAnimationList();

	/**
	 * N̏o
	 */
	virtual void writeLink();

	//--------------------------------------------------------------------------
	// Aj[VZbg
	//--------------------------------------------------------------------------
	/**
	 * Aj[VZbg̏o
	 * @param animation oAj[VZbg
	 */
	virtual void writeAnimationSet(AnimationSet* animation);

	//--------------------------------------------------------------------------
	// J
	//--------------------------------------------------------------------------
	/**
	 * JAj[V̏o
	 * @param animation oJAj[V
	 */
	virtual void writeCameraAnimation(CameraAnimation* animation);

	/**
	 * JAj[Vf[^̏o
	 * @param data oJAj[Vf[^
	 */
	virtual void writeCameraAnimationData(CameraAnimationData* data);

	//--------------------------------------------------------------------------
	// V[m[h
	//--------------------------------------------------------------------------
	/**
	 * V[m[hAj[V̏o
	 * @param animation oV[m[hAj[V
	 */
	virtual void writeSceneNodeAnimation(SceneNodeAnimation* animation);

	/**
	 * V[m[hAj[Vf[^̏o
	 * @param data oV[m[hAj[Vf[^
	 */
	virtual void writeSceneNodeAnimationData(SceneNodeAnimationData* data);

	//--------------------------------------------------------------------------
	// f
	//--------------------------------------------------------------------------
	/**
	 * LN^fAj[V̏o
	 * @param animation oLN^fAj[V
	 */
	virtual void writeCharacterModelAnimation(
		CharacterModelAnimation* animation);

	/**
	 * LN^fAj[Vf[^̏o
	 * @param data oLN^fAj[Vf[^
	 */
	virtual void writeCharacterModelAnimationData(
		CharacterModelAnimationData* data);

	//--------------------------------------------------------------------------
	// N
	//--------------------------------------------------------------------------
	/**
	 * Aj[VZbgN̏o
	 * @param animation NoAj[VZbg
	 */
	virtual void writeAnimationSetLink(AnimationSet* animation);

	/**
	 * JAj[VN̏o
	 * @param animation NoJAj[V
	 */
	virtual void writeCameraAnimationLink(CameraAnimation* animation);

	/**
	 * V[m[hAj[VN̏o
	 * @param animation NoV[m[hAj[V
	 */
	virtual void writeSceneNodeAnimationLink(SceneNodeAnimation* animation);

	/**
	 * LN^fAj[VN̏o
	 * @param animation NoLN^fAj[V
	 */
	virtual void writeCharacterModelAnimationLink(
		CharacterModelAnimation* animation);

	//--------------------------------------------------------------------------
	// xNg
	//--------------------------------------------------------------------------
	/**
	 * xNgԂ̏o
	 * @param interpolator xNg
	 * @param name O
	 * @param tabDepth ^u[x
	 */
	virtual void writeVectorInterpolator(
		VectorInterpolator* interpolator,
		const String& name, const String& tabDepth);

	/**
	 * xNg萔Ԃ̏o
	 * @param interpolator xNg萔
	 * @param name O
	 * @param tabDepth ^u[x
	 */
	virtual void writeVectorConstantInterpolator(
		VectorConstantInterpolator* interpolator,
		const String& name, const String& tabDepth);

	/**
	 * xNgzԂ̏o
	 * @param interpolator xNgz
	 * @param name O
	 * @param tabDepth ^u[x
	 */
	virtual void writeVectorArrayInterpolator(
		VectorArrayInterpolator* interpolator,
		const String& name, const String& tabDepth);

	/**
	 * xNg`Ԃ̏o
	 * @param interpolator xNg`
	 * @param name O
	 * @param tabDepth ^u[x
	 */
	virtual void writeVectorLinearInterpolator(
		VectorLinearInterpolator* interpolator,
		const String& name, const String& tabDepth);

	//--------------------------------------------------------------------------
	// ]
	//--------------------------------------------------------------------------
	/**
	 * ]Ԃ̏o
	 * @param interpolator ]
	 * @param name O
	 * @param tabDepth ^u[x
	 */
	virtual void writeRotationInterpolator(
		RotationInterpolator* interpolator,
		const String& name, const String& tabDepth);

	/**
	 * ]萔Ԃ̏o
	 * @param interpolator ]萔
	 * @param name O
	 * @param tabDepth ^u[x
	 */
	virtual void writeRotationConstantInterpolator(
		RotationConstantInterpolator* interpolator,
		const String& name, const String& tabDepth);

	/**
	 * IC[]zԂ̏o
	 * @param interpolator IC[]z
	 * @param name O
	 * @param tabDepth ^u[x
	 */
	virtual void writeEulerArrayInterpolator(
		EulerArrayInterpolator* interpolator,
		const String& name, const String& tabDepth);

	/**
	 * l]zԂ̏o
	 * @param interpolator l]z
	 * @param name O
	 * @param tabDepth ^u[x
	 */
	virtual void writeQuaternionArrayInterpolator(
		QuaternionArrayInterpolator* interpolator,
		const String& name, const String& tabDepth);

	/**
	 * l]`Ԃ̏o
	 * @param interpolator l]`
	 * @param name O
	 * @param tabDepth ^u[x
	 */
	virtual void writeQuaternionLinearInterpolator(
		QuaternionLinearInterpolator* interpolator,
		const String& name, const String& tabDepth);

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * bool̏o
	 */
	virtual void writeBool(bool);

	/**
	 * Rg̏o
	 */
	virtual void writeLineComment();

	/**
	 * ubNRg̏o
	 * @param blockName ubN
	 */
	virtual void writeBlockComment(const String& blockName);

	/// C^
	TextWriter* writer_;
	/// Aj[V}l[W
	AnimationManager* manager_;

	/// Aj[VJEg
	int animationCount_;
	/// Aj[VZbgJEg
	int animationSetCount_;
	/// JAj[VJEg
	int cameraCount_;
	/// V[m[hAj[VJEg
	int sceneNodeCount_;
	/// LN^fAj[VJEg
	int characterModelCount_;

	/// Aj[Vf[^JEg
	int animationDataCount_;
	/// JAj[Vf[^JEg
	int cameraDataCount_;
	/// V[m[hAj[Vf[^JEg
	int sceneNodeDataCount_;
	/// LN^fAj[Vf[^JEg
	int characterModelDataCount_;

private:
	// Rs[RXgN^̉B
	TextAnimationSaver(const TextAnimationSaver& copy);

	// Rs[̉B
	void operator =(const TextAnimationSaver& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEXT_ANIMATION_SAVER_H_
//------------------------------------------------------------------------------
