//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgAj[V[_wb_
 * @author Junpee
 */

#ifndef TEXT_ANIMATION_LOADER_H_
#define TEXT_ANIMATION_LOADER_H_

namespace Lamp{

class TextReader;
class StreamTokenizer;
class AnimationManager;
class VectorInterpolator;
class RotationInterpolator;

//------------------------------------------------------------------------------
/**
 * eLXgAj[V[_
 */
class TextAnimationLoader{
public:
	/**
	 * RXgN^
	 */
	TextAnimationLoader();

	/**
	 * fXgN^
	 */
	virtual ~TextAnimationLoader();

	/**
	 * [h
	 * @param filePath t@CpX
	 * @param manager [hAj[V}l[W
	 */
	virtual void load(const String& filePath, AnimationManager* manager);

	/**
	 * [h
	 * @param textReader eLXg[_
	 * @param manager [hAj[V}l[W
	 */
	virtual void load(TextReader* textReader, AnimationManager* manager);

protected:
	/**
	 * wb_̓ǂݍ
	 */
	virtual void readHeader();

	//--------------------------------------------------------------------------
	// Aj[VZbg
	//--------------------------------------------------------------------------
	/**
	 * Aj[VZbgXg̓ǂݍ
	 */
	virtual void readAnimationSetList();

	/**
	 * Aj[VZbg̓ǂݍ
	 * @param name O
	 */
	virtual void readAnimationSet(const String& name);

	//--------------------------------------------------------------------------
	// J
	//--------------------------------------------------------------------------
	/**
	 * JAj[V̓ǂݍ
	 * @param name O
	 */
	virtual void readCameraAnimation(const String& name);

	/**
	 * JAj[Vf[^̓ǂݍ
	 * @param name O
	 */
	virtual void readCameraAnimationData(const String& name);

	//--------------------------------------------------------------------------
	// V[m[h
	//--------------------------------------------------------------------------
	/**
	 * V[m[hAj[V̓ǂݍ
	 * @param name O
	 */
	virtual void readSceneNodeAnimation(const String& name);

	/**
	 * V[m[hAj[Vf[^̓ǂݍ
	 * @param name O
	 */
	virtual void readSceneNodeAnimationData(const String& name);

	//--------------------------------------------------------------------------
	// f
	//--------------------------------------------------------------------------
	/**
	 * LN^fAj[V̓ǂݍ
	 * @param name O
	 */
	virtual void readCharacterModelAnimation(const String& name);

	/**
	 * LN^fAj[Vf[^̓ǂݍ
	 * @param name O
	 */
	virtual void readCharacterModelAnimationData(const String& name);

	//--------------------------------------------------------------------------
	// Aj[VZbgN
	//--------------------------------------------------------------------------
	/**
	 * Aj[VZbgNXg̓ǂݍ
	 */
	virtual void readAnimationSetLinkList();

	/**
	 * Aj[VZbgN̓ǂݍ
	 * @param name O
	 */
	virtual void readAnimationSetLink(const String& name);

	//--------------------------------------------------------------------------
	// JAj[VN
	//--------------------------------------------------------------------------
	/**
	 * JAj[VNXgǂݍ
	 */
	virtual void readCameraLinkList();

	//--------------------------------------------------------------------------
	// V[m[hAj[VN
	//--------------------------------------------------------------------------
	/**
	 * V[m[hAj[VNXgǂݍ
	 */
	virtual void readSceneNodeLinkList();

	//--------------------------------------------------------------------------
	// LN^fAj[VN
	//--------------------------------------------------------------------------
	/**
	 * LN^fAj[VNXgǂݍ
	 */
	virtual void readCharacterModelLinkList();

	//--------------------------------------------------------------------------
	// l̓ǂݍ
	//--------------------------------------------------------------------------
	/**
	 * booll̓ǂݍ
	 * @return booll
	 */
	virtual bool readBool();

	/**
	 * intl̓ǂݍ
	 * @return intl
	 */
	virtual int readInt();

	/**
	 * floatl̓ǂݍ
	 * @return floatl
	 */
	virtual float readFloat();

	/**
	 * Vector3l̓ǂݍ
	 * @return Vector3l
	 */
	virtual Vector3 readVector3();

	/**
	 * Quaternionl̓ǂݍ
	 * @return Quaternionl
	 */
	virtual Quaternion readQuaternion();

	//--------------------------------------------------------------------------
	// xNgԂ̓ǂݍ
	//--------------------------------------------------------------------------
	/**
	 * xNgԂ̓ǂݍ
	 * @return xNg
	 */
	virtual VectorInterpolator* readVectorInterpolator();

	/**
	 * xNg萔Ԃ̓ǂݍ
	 * @return xNg萔
	 */
	virtual VectorInterpolator* readVectorConstantInterpolator();

	/**
	 * xNgzԂ̓ǂݍ
	 * @return xNgz
	 */
	virtual VectorInterpolator* readVectorArrayInterpolator();

	/**
	 * xNg`Ԃ̓ǂݍ
	 * @return xNg`
	 */
	virtual VectorInterpolator* readVectorLinearInterpolator();

	//--------------------------------------------------------------------------
	// ]Ԃ̓ǂݍ
	//--------------------------------------------------------------------------
	/**
	 * ]Ԃ̓ǂݍ
	 * @return ]
	 */
	virtual RotationInterpolator* readRotationInterpolator();

	/**
	 * ]萔Ԃ̓ǂݍ
	 * @return ]萔
	 */
	virtual RotationInterpolator* readRotationConstantInterpolator();

	/**
	 * IC[]zԂ̓ǂݍ
	 * @return IC[]z
	 */
	virtual RotationInterpolator* readEulerArrayInterpolator();

	/**
	 * l]zԂ̓ǂݍ
	 * @return l]z
	 */
	virtual RotationInterpolator* readQuaternionArrayInterpolator();

	/**
	 * l]`Ԃ̓ǂݍ
	 * @return l]`
	 */
	virtual RotationInterpolator* readQuaternionLinearInterpolator();

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * g[N̓ǂݍ
	 * @param caller Ăяo
	 */
	virtual String readToken(const String& caller);

	/**
	 * w胏[h̓ǂݔ΂
	 * @param word ǂݔ΂[h
	 */
	virtual void skipWord(const String& word);

	/**
	 * `NJ
	 */
	virtual void openChunk(){ skipWord("{"); }

	/**
	 * `N
	 */
	virtual void closeChunk(){ skipWord("}"); }

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	/// g[NiCU
	StreamTokenizer* tokenizer_;
	/// Aj[V}l[W
	AnimationManager* manager_;

private:
	// Rs[RXgN^̉B
	TextAnimationLoader(const TextAnimationLoader& copy);

	// Rs[̉B
	void operator =(const TextAnimationLoader& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEXT_ANIMATION_LOADER_H_
//------------------------------------------------------------------------------
