//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oCiAj[VZ[owb_
 * @author Junpee
 */

#ifndef BINARY_ANIMATION_SAVER_H_
#define BINARY_ANIMATION_SAVER_H_

namespace Lamp{

class BinaryWriter;
class AnimationManager;
class AnimationSet;
class CameraAnimation;
class CameraAnimationData;
class SceneNodeAnimation;
class SceneNodeAnimationData;
class CharacterModelAnimation;
class CharacterModelAnimationData;

class VectorInterpolator;
class VectorConstantInterpolator;
class VectorArrayInterpolator;
class VectorLinearInterpolator;
class RotationInterpolator;
class RotationConstantInterpolator;
class EulerArrayInterpolator;
class QuaternionArrayInterpolator;
class QuaternionLinearInterpolator;

//------------------------------------------------------------------------------
/**
 * oCiAj[VZ[o
 */
class BinaryAnimationSaver{
public:
	/**
	 * RXgN^
	 */
	BinaryAnimationSaver();

	/**
	 * fXgN^
	 */
	virtual ~BinaryAnimationSaver();

	//--------------------------------------------------------------------------
	// Z[u
	//--------------------------------------------------------------------------
	/**
	 * Z[u
	 * @param filePath t@CpX
	 * @param manager Z[uAj[V}l[W
	 */
	virtual void save(const String& filePath, AnimationManager* manager);

	/**
	 * Z[u
	 * @param binaryWriter oCiC^
	 * @param manager Z[uAj[V}l[W
	 */
	virtual void save(BinaryWriter* binaryWriter, AnimationManager* manager);

protected:
	//--------------------------------------------------------------------------
	/**
	 * wb_̏o
	 */
	virtual void writeHeader();

	/**
	 * IuWFNg̃JEg
	 * @return IuWFNg
	 */
	virtual int countObjects();

	/**
	 * IuWFNgJE^̃NA
	 */
	virtual void clearObjectCount(){
		animationCount_ = animationDataCount_ = animationSetCount_ =
		cameraCount_ = cameraDataCount_ =
		sceneNodeCount_ = sceneNodeDataCount_ =
		characterModelCount_ = characterModelDataCount_ = 0;
	}

	//--------------------------------------------------------------------------
	// Aj[VXg
	//--------------------------------------------------------------------------
	/**
	 * Aj[VXg̏o
	 */
	virtual void writeAnimationList();

	//--------------------------------------------------------------------------
	/**
	 * Aj[VZbg̏o
	 * @param animation oAj[VZbg
	 */
	virtual void writeAnimationSet(AnimationSet* animation);

	//--------------------------------------------------------------------------
	/**
	 * JAj[V̏o
	 * @param animation oJAj[V
	 */
	virtual void writeCameraAnimation(CameraAnimation* animation);

	/**
	 * JAj[Vf[^̏o
	 * @param data oJAj[Vf[^
	 */
	virtual void writeCameraAnimationData(CameraAnimationData* data);

	//--------------------------------------------------------------------------
	/**
	 * V[m[hAj[V̏o
	 * @param animation oV[m[hAj[V
	 */
	virtual void writeSceneNodeAnimation(SceneNodeAnimation* animation);

	/**
	 * V[m[hAj[Vf[^̏o
	 * @param data oV[m[hAj[Vf[^
	 */
	virtual void writeSceneNodeAnimationData(SceneNodeAnimationData* data);

	//--------------------------------------------------------------------------
	/**
	 * LN^fAj[V̏o
	 * @param animation oLN^fAj[V
	 */
	virtual void writeCharacterModelAnimation(
		CharacterModelAnimation* animation);

	/**
	 * LN^fAj[Vf[^̏o
	 * @param data oLN^fAj[Vf[^
	 */
	virtual void writeCharacterModelAnimationData(
		CharacterModelAnimationData* data);

	//--------------------------------------------------------------------------
	// N
	//--------------------------------------------------------------------------
	/**
	 * N̏o
	 */
	virtual void writeLink();

	/**
	 * Aj[VZbgN̏o
	 * @param animation NoAj[VZbg
	 */
	virtual void writeAnimationSetLink(AnimationSet* animation);

	/**
	 * JAj[VN̏o
	 * @param animation NoJAj[V
	 */
	virtual void writeCameraAnimationLink(CameraAnimation* animation);

	/**
	 * V[m[hAj[VN̏o
	 * @param animation NoV[m[hAj[V
	 */
	virtual void writeSceneNodeAnimationLink(SceneNodeAnimation* animation);

	/**
	 * LN^fAj[VN̏o
	 * @param animation NoLN^fAj[V
	 */
	virtual void writeCharacterModelAnimationLink(
		CharacterModelAnimation* animation);

	//--------------------------------------------------------------------------
	// l̏o
	//--------------------------------------------------------------------------
	/**
	 * ̏o
	 * @param string 
	 */
	virtual void writeString(const String& string);

	/**
	 * OxNg̏o
	 * @param vector OxNg
	 */
	virtual void writeVector3(const Vector3& vector);

	/**
	 * l̏o
	 * @param quaternion l
	 */
	virtual void writeQuaternion(const Quaternion& quaternion);

	//--------------------------------------------------------------------------
	// xNg
	//--------------------------------------------------------------------------
	/**
	 * xNgԂ̏o
	 * @param interpolator xNg
	 */
	virtual void writeVectorInterpolator(
		VectorInterpolator* interpolator);

	/**
	 * xNg萔Ԃ̏o
	 * @param interpolator xNg萔
	 */
	virtual void writeVectorConstantInterpolator(
		VectorConstantInterpolator* interpolator);

	/**
	 * xNgzԂ̏o
	 * @param interpolator xNgz
	 */
	virtual void writeVectorArrayInterpolator(
		VectorArrayInterpolator* interpolator);

	/**
	 * xNg`Ԃ̏o
	 * @param interpolator xNg`
	 */
	virtual void writeVectorLinearInterpolator(
		VectorLinearInterpolator* interpolator);

	//--------------------------------------------------------------------------
	// ]
	//--------------------------------------------------------------------------
	/**
	 * ]Ԃ̏o
	 * @param interpolator ]
	 */
	virtual void writeRotationInterpolator(
		RotationInterpolator* interpolator);

	/**
	 * ]萔Ԃ̏o
	 * @param interpolator ]萔
	 */
	virtual void writeRotationConstantInterpolator(
		RotationConstantInterpolator* interpolator);

	/**
	 * IC[]zԂ̏o
	 * @param interpolator IC[]z
	 */
	virtual void writeEulerArrayInterpolator(
		EulerArrayInterpolator* interpolator);

	/**
	 * l]zԂ̏o
	 * @param interpolator l]z
	 */
	virtual void writeQuaternionArrayInterpolator(
		QuaternionArrayInterpolator* interpolator);

	/**
	 * l]`Ԃ̏o
	 * @param interpolator l]`
	 */
	virtual void writeQuaternionLinearInterpolator(
		QuaternionLinearInterpolator* interpolator);

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * ACg
	 */
	virtual void align();

	/**
	 * ubN̊Jn
	 * @param blockName ubN
	 * @return vbNJnʒu
	 */
	virtual int startBlock(const String& blockName);

	/**
	 * ubN̏I
	 * @param blockStartAddress ubNJnʒu
	 * @param objectCount IuWFNg
	 */
	virtual void endBlock(int blockStartAddress, int objectCount);

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	/// C^
	BinaryWriter* writer_;
	/// Aj[V}l[W
	AnimationManager* manager_;

	/// Aj[VJEg
	int animationCount_;
	/// Aj[Vf[^JEg
	int animationDataCount_;
	/// Aj[VZbgJEg
	int animationSetCount_;
	/// JAj[VJEg
	int cameraCount_;
	/// JAj[Vf[^JEg
	int cameraDataCount_;
	/// V[m[hAj[VJEg
	int sceneNodeCount_;
	/// V[m[hAj[Vf[^JEg
	int sceneNodeDataCount_;
	/// LN^fAj[VJEg
	int characterModelCount_;
	/// LN^fAj[Vf[^JEg
	int characterModelDataCount_;

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	BinaryAnimationSaver(const BinaryAnimationSaver& copy);

	// Rs[̉B
	void operator =(const BinaryAnimationSaver& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BINARY_ANIMATION_SAVER_H_
//------------------------------------------------------------------------------
