//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oCiAj[V[_wb_
 * @author Junpee
 */

#ifndef BINARY_ANIMATION_LOADER_H_
#define BINARY_ANIMATION_LOADER_H_

namespace Lamp{

class BinaryReader;
class AnimationManager;
class VectorInterpolator;
class RotationInterpolator;

//------------------------------------------------------------------------------
/**
 * oCiAj[V[_
 */
class BinaryAnimationLoader{
public:
	/**
	 * RXgN^
	 */
	BinaryAnimationLoader();

	/**
	 * fXgN^
	 */
	virtual ~BinaryAnimationLoader();

	//--------------------------------------------------------------------------
	// [h
	//--------------------------------------------------------------------------
	/**
	 * [h
	 * @param filePath t@CpX
	 * @param manager [hAj[V}l[W
	 */
	virtual void load(const String& filePath, AnimationManager* manager);

	/**
	 * [h
	 * @param binaryReader eLXg[_
	 * @param manager [hAj[V}l[W
	 */
	virtual void load(BinaryReader* binaryReader, AnimationManager* manager);

protected:
	//--------------------------------------------------------------------------
	/**
	 * wb_̓ǂݍ
	 */
	virtual void readHeader();

	//--------------------------------------------------------------------------
	// Aj[VZbg
	//--------------------------------------------------------------------------
	/**
	 * Aj[VZbg̓ǂݍ
	 */
	virtual void readAnimationSet();

	//--------------------------------------------------------------------------
	// J
	//--------------------------------------------------------------------------
	/**
	 * JAj[V̓ǂݍ
	 */
	virtual void readCameraAnimation();

	/**
	 * JAj[Vf[^̓ǂݍ
	 */
	virtual void readCameraAnimationData();

	//--------------------------------------------------------------------------
	// V[m[h
	//--------------------------------------------------------------------------
	/**
	 * V[m[hAj[V̓ǂݍ
	 */
	virtual void readSceneNodeAnimation();

	/**
	 * V[m[hAj[Vf[^̓ǂݍ
	 */
	virtual void readSceneNodeAnimationData();

	//--------------------------------------------------------------------------
	// LN^f
	//--------------------------------------------------------------------------
	/**
	 * LN^fAj[V̓ǂݍ
	 */
	virtual void readCharacterModelAnimation();

	/**
	 * LN^fAj[Vf[^̓ǂݍ
	 */
	virtual void readCharacterModelAnimationData();

	//--------------------------------------------------------------------------
	// N
	//--------------------------------------------------------------------------
	/**
	 * Aj[VZbgN̓ǂݍ
	 */
	virtual void readAnimationSetLink();

	/**
	 * JAj[VN̓ǂݍ
	 */
	virtual void readCameraAnimationLink();

	/**
	 * V[m[hAj[VN̓ǂݍ
	 */
	virtual void readSceneNodeAnimationLink();

	/**
	 * LN^fAj[VN̓ǂݍ
	 */
	virtual void readCharacterModelAnimationLink();

	//--------------------------------------------------------------------------
	// xNgԂ̓ǂݍ
	//--------------------------------------------------------------------------
	/**
	 * xNgԂ̓ǂݍ
	 * @return xNg
	 */
	virtual VectorInterpolator* readVectorInterpolator();

	/**
	 * xNg萔Ԃ̓ǂݍ
	 * @return xNg萔
	 */
	virtual VectorInterpolator* readVectorConstantInterpolator();

	/**
	 * xNgzԂ̓ǂݍ
	 * @return xNgz
	 */
	virtual VectorInterpolator* readVectorArrayInterpolator();

	/**
	 * xNg`Ԃ̓ǂݍ
	 * @return xNg`
	 */
	virtual VectorInterpolator* readVectorLinearInterpolator();

	//--------------------------------------------------------------------------
	// ]Ԃ̓ǂݍ
	//--------------------------------------------------------------------------
	/**
	 * ]Ԃ̓ǂݍ
	 * @return ]
	 */
	virtual RotationInterpolator* readRotationInterpolator();

	/**
	 * ]萔Ԃ̓ǂݍ
	 * @return ]萔
	 */
	virtual RotationInterpolator* readRotationConstantInterpolator();

	/**
	 * IC[]zԂ̓ǂݍ
	 * @return IC[]z
	 */
	virtual RotationInterpolator* readEulerArrayInterpolator();

	/**
	 * l]zԂ̓ǂݍ
	 * @return l]z
	 */
	virtual RotationInterpolator* readQuaternionArrayInterpolator();

	/**
	 * l]`Ԃ̓ǂݍ
	 * @return l]`
	 */
	virtual RotationInterpolator* readQuaternionLinearInterpolator();

	//--------------------------------------------------------------------------
	// l̓ǂݍ
	//--------------------------------------------------------------------------
	/**
	 * ̓ǂݍ
	 * @return 
	 */
	virtual String readString();

	/**
	 * OxNg̓ǂݍ
	 * @return OxNg
	 */
	virtual Vector3 readVector3();

	/**
	 * l̓ǂݍ
	 * @return l
	 */
	virtual Quaternion readQuaternion();

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * ACg
	 */
	virtual void align();

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	/// [_
	BinaryReader* reader_;
	/// Aj[V}l[W
	AnimationManager* manager_;

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	BinaryAnimationLoader(const BinaryAnimationLoader& copy);

	// Rs[̉B
	void operator =(const BinaryAnimationLoader& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BINARY_ANIMATION_LOADER_H_
//------------------------------------------------------------------------------
