//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * JAj[Vf[^wb_
 * @author Junpee
 */

#ifndef CAMERA_ANIMATION_DATA_H_
#define CAMERA_ANIMATION_DATA_H_

#include <Animation/System/AnimationData.h>
#include <Animation/VectorInterpolator/VectorInterpolator.h>
#include <Animation/RotationInterpolator/RotationInterpolator.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * JAj[Vf[^
 */
class CameraAnimationData : public AnimationData{
friend class AnimationManager;
protected:
	//--------------------------------------------------------------------------
	/**
	 * JV[PX
	 */
	class CameraSequence : public Sequence{
	public:
		/**
		 * RXgN^
		 */
		CameraSequence() : Sequence(),
			rotation_(NULL), translation_(NULL){}

		/**
		 * fXgN^
		 */
		virtual ~CameraSequence(){
			SafeDelete(translation_);
			SafeDelete(rotation_);
		}

		/**
		 * Rs[
		 * @param copy Rs[
		 */
		virtual void operator =(const CameraSequence& copy){
			Sequence::operator=(copy);
			SafeDelete(translation_);
			SafeDelete(rotation_);
			if(copy.rotation_ != NULL){ 
				rotation_ = copy.rotation_->duplicate();
			}
			if(copy.translation_ != NULL){
				translation_ = copy.translation_->duplicate();
			}
		}

		/**
		 * ̌vZ
		 */
		virtual void calcLength(){
			length_ = 0.f;
			if((rotation_ != NULL) && (rotation_->getLength() > length_)){
				length_ = rotation_->getLength();
			}
			if((translation_ != NULL) &&
				(translation_->getLength() > length_)){
				length_ = translation_->getLength();
			}
		}

		/// ]
		RotationInterpolator* rotation_;
		/// ړ
		VectorInterpolator* translation_;

	};

public:
	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @return Rs[ꂽAj[Vf[^
	 */
	virtual AnimationData* copy() const{ return copyCameraAnimationData(); }

	/**
	 * JAj[Vf[^̃Rs[
	 */
	virtual CameraAnimationData* copyCameraAnimationData() const;

	//--------------------------------------------------------------------------
	// V[PX
	//--------------------------------------------------------------------------
	/**
	 * V[PX̐ݒ
	 * @param sequenceCount V[PX
	 */
	virtual void setSequenceCount(int sequenceCount){
		SafeArrayDelete(sequences_);
		sequenceCount_ = sequenceCount;
		if(sequenceCount_ == 0){ return; }
		sequences_ = new CameraSequence[sequenceCount_];
	}

	/**
	 * V[PX̎擾
	 * @return V[PX
	 */
	virtual int getSequenceCount() const{ return sequenceCount_; }

	//--------------------------------------------------------------------------
	// ]
	//--------------------------------------------------------------------------
	/**
	 * ]̐ݒ
	 * @param sequence V[PX
	 * @param rotation ݒ肷]
	 */
	virtual void setRotation(int sequence, RotationInterpolator* rotation){
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		CameraSequence& data = sequences_[sequence];
		SafeDelete(data.rotation_);
		data.rotation_ = rotation;
		data.calcLength();
	}

	/**
	 * ]̎擾
	 * @param sequence V[PX
	 * @return ]
	 */
	virtual RotationInterpolator* getRotation(int sequence) const{
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return sequences_[sequence].rotation_;
	}

	//--------------------------------------------------------------------------
	// ړ
	//--------------------------------------------------------------------------
	/**
	 * ړ̐ݒ
	 * @param sequence V[PX
	 * @param translation ݒ肷ړ
	 */
	virtual void setTranslation(
		int sequence, VectorInterpolator* translation){
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		CameraSequence& data = sequences_[sequence];
		SafeDelete(data.translation_);
		data.translation_ = translation;
		data.calcLength();
	}

	/**
	 * ړ̎擾
	 * @param sequence V[PX
	 * @return ړ
	 */
	virtual VectorInterpolator* getTranslation(int sequence) const{
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return sequences_[sequence].translation_;
	}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * JAj[Vf[^ǂ
	 * @return JAj[Vf[^Ȃtrue
	 */
	virtual bool isCameraAnimationData() const{ return true; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param manager Aj[V}l[W
	 */
	CameraAnimationData(const String& name, AnimationManager* manager) :
		AnimationData(name, manager), sequenceCount_(0), sequences_(NULL){
	}

	/**
	 * fXgN^
	 */
	virtual ~CameraAnimationData(){
		SafeArrayDelete(sequences_);
	}

	//--------------------------------------------------------------------------
	/**
	 * V[PX̎擾
	 * @param sequence V[PX
	 * @return V[PX
	 */
	virtual Sequence* getSequence(int sequence){
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return &sequences_[sequence];
	}

	/**
	 * V[PX̎擾
	 * @param sequence V[PX
	 * @return V[PX
	 */
	virtual const Sequence* getSequence(int sequence) const{
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return &sequences_[sequence];
	}

	//--------------------------------------------------------------------------
private:
	// V[PX
	int sequenceCount_;
	// V[PX
	CameraSequence* sequences_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of CAMERA_ANIMATION_DATA_H_
//------------------------------------------------------------------------------
