//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * JAj[Vwb_
 * @author Junpee
 */

#ifndef CAMERA_ANIMATION_H_
#define CAMERA_ANIMATION_H_

#include <Animation/System/ObjectAnimation.h>
#include <Animation/Camera/CameraAnimationData.h>

namespace Lamp{

class Camera;

//------------------------------------------------------------------------------
/**
 * JAj[V
 */
class CameraAnimation : public ObjectAnimation{
friend class AnimationManager;
public:
	//--------------------------------------------------------------------------
	// Aj[Vf[^
	//--------------------------------------------------------------------------
	/**
	 * Aj[Vf[^̎擾
	 * @return Aj[Vf[^
	 */
	virtual AnimationData* getAnimationData(){ return animationData_; }

	/**
	 * Aj[Vf[^̎擾
	 * @return Aj[Vf[^
	 */
	virtual const AnimationData* getAnimationData() const{
		return animationData_;
	}

	//--------------------------------------------------------------------------
	// JAj[Vf[^
	//--------------------------------------------------------------------------
	/**
	 * JAj[Vf[^̐ݒ
	 * @param animationData JAj[Vf[^
	 */
	virtual void setCameraAnimationData(CameraAnimationData* animationData){
		if(animationData_ != NULL){ animationData_->removeReference(); }
		animationData_ = animationData;
		if(animationData_ != NULL){ animationData_->addReference(); }
	}

	/**
	 * JAj[Vf[^̎擾
	 * @return JAj[Vf[^
	 */
	virtual CameraAnimationData* getCameraAnimationData(){
		return animationData_;
	}

	/**
	 * JAj[Vf[^̎擾
	 * @return JAj[Vf[^
	 */
	virtual const CameraAnimationData* getCameraAnimationData() const{
		return animationData_;
	}

	//--------------------------------------------------------------------------
	// oCh
	//--------------------------------------------------------------------------
	/**
	 * oCh
	 * @param scene oChΏۃV[
	 * @return true
	 */
	virtual bool bind(Scene* scene);

	/**
	 * oCh
	 * @param camera oChΏۃJ
	 * @return true
	 */
	virtual bool bind(Camera* camera);

	/**
	 * oCh
	 */
	virtual void unbind(){ target_ = NULL; }

	/**
	 * ^[Qbg̎擾
	 * @return ^[Qbg
	 */
	virtual Camera* getTarget() const{ return target_; }

	//--------------------------------------------------------------------------
	// Aj[V
	//--------------------------------------------------------------------------
	/**
	 * Aj[V
	 * @param deltaTime f^^C
	 * @param mask Aj[V}XN
	 * @return Aj[VIĂtrue
	 */
	virtual bool animate(float deltaTime, AnimationMask mask);

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param dataCopyMask f[^Rs[}XN
	 * @return Rs[ꂽAj[V
	 */
	virtual Animation* copy(DataCopyMask dataCopyMask = copyNone) const{
		return copyCameraAnimation(dataCopyMask);
	}

	/**
	 * JAj[ṼRs[
	 * @param dataCopyMask f[^Rs[}XN
	 * @return Rs[ꂽAj[V
	 */
	virtual CameraAnimation* copyCameraAnimation(
		DataCopyMask dataCopyMask = copyNone) const;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * JAj[Vǂ
	 * @return JAj[VȂtrue
	 */
	virtual bool isCameraAnimation() const{ return true; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param manager Aj[V}l[W
	 */
	CameraAnimation(String name, AnimationManager* manager);

	/**
	 * fXgN^
	 */
	virtual ~CameraAnimation();

private:
	// Aj[Vf[^
	CameraAnimationData* animationData_;
	// ^[Qbg
	Camera* target_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of CAMERA_ANIMATION_H_
//------------------------------------------------------------------------------

