//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ^Cg^XN
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Title/TitleTask.h"
#include "Game/System/GameSystem.h"
#include "Load/System/LoadTask.h"
#include "Game/Rendering/RenderingSystem.h"
#include "Game/Sound/SoundSystem.h"
#include "Game/Input/GamePad.h"
#include "Stage/System/Stage.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
TitleTask::TitleTask() : GameTask(), sceneNode_(NULL), logoNode_(NULL),
	bgm_(NULL), gameStartSE_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
TitleTask::~TitleTask(){
}
//------------------------------------------------------------------------------
// [h
//------------------------------------------------------------------------------
// [h
void TitleTask::load(){
	// [h^XN̍\z
	LoadTask* loadTask = getGameSystem()->getLoadTask();
	loadTask->setNextTask(this);

	// V[̃[h
	Assert(sceneNode_ == NULL);
	sceneNode_ =
		getScene()->getSceneNodeManager()->createSceneNode("TitleTask");
	getScene()->getRootNode()->addSceneNode(sceneNode_);
	loadTask->requestScene("Media/Title/Title.bsn", getScene(), sceneNode_);

	// [h^XN̓o^
	getGameSystem()->setNextTask(loadTask);
}
//------------------------------------------------------------------------------
// An
//------------------------------------------------------------------------------
// 
void TitleTask::initialize(){
	// Sm[h
	logoNode_ = getScene()->getSceneNodeManager()->search("LogoGroup");
	Assert(logoNode_ != NULL);

/*
	// Cgm[h
	Assert(lightNode_ == NULL);
	lightNode_ = getScene()->getSceneNodeManager()->createSceneNode(
		"CameraLightNode");
	getScene()->getRootNode()->addSceneNode(lightNode_);
	PointLight* cameraLight = getScene()->getLightManager()->createPointLight(
		"CameraLight");
	lightNode_->addSceneLeaf(cameraLight);
	cameraLight->setColor(Color3f(800.f, 600.f, 800.f));
	cameraLight->setAttenuation(0.f, 0.f, 1.f);
	cameraLight->setRange(150.f);
	cameraLight->setLightMask(3);
*/

	// tHOݒ
	getScene()->getFog()->setMode(Fog::modeLinear);
	getScene()->getFog()->setEnabled(true);
	getScene()->getFog()->setNear(100.f);
	getScene()->getFog()->setFar(500.f);
	getScene()->getFog()->setColor(Color4c(192, 128,  255, 0));

	// BGM̍Đ
	bgm_ = getSoundManager()->createStreamSound("Media/BGM/Title.ogg");
	bgm_->applyCommentOption();
	bgm_->play();

	// Q[JnSE
	gameStartSE_ =
		getSoundManager()->createStaticSound("Media/SE/GameStart.ogg");

	// JE^
	enterGameCounter_ = -1;
	runCounter_ = 0;
}
//------------------------------------------------------------------------------
// n
void TitleTask::finalize(){
	// Q[JnSE̔j
	gameStartSE_->stop();
	getSoundManager()->destroy(gameStartSE_);
	// BGM̔j
	bgm_->stop();
	getSoundManager()->destroy(bgm_);

/*
	// Aj[ṼNAANAs
	getAnimationSystem()->clear();

	// Cgm[h̔j
	SceneNode::recursiveDestroy(lightNode_);
	lightNode_ = NULL;
*/
	// Sm[h̃NA
	logoNode_ = NULL;

	// V[̔j
	SceneNode::recursiveDestroy(sceneNode_);
	sceneNode_ = NULL;
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// s
void TitleTask::run(){
	// Q[Jn
	if(enterGameCounter_ < 0){
		bool enterGame = false;
		GamePad* pad = getGamePad();
		if(pad != NULL){
			if(pad->buttonDown(GamePad::button0) ||
				pad->buttonDown(GamePad::button1) ||
				pad->buttonDown(GamePad::button2) ||
				pad->buttonDown(GamePad::button3)){
				enterGame = true;
			}
		}
		if(getMouse()->buttonDown(0) ||
			getMouse()->buttonDown(1) ||
			getMouse()->buttonDown(2)){
			enterGame = true;
		}
		enterGame |= getKeyboard()->down(Keyboard::keyJ);
		enterGame |= getKeyboard()->down(Keyboard::keyK);
		enterGame |= getKeyboard()->down(Keyboard::keyL);
		enterGame |= getKeyboard()->down(Keyboard::keyC);
		enterGame |= getKeyboard()->down(Keyboard::keyX);
		enterGame |= getKeyboard()->down(Keyboard::keyZ);
		if(enterGame){
			gameStartSE_->play();
			enterGameCounter_ = 96;
		}
	}
	if(enterGameCounter_ >= 0){
		if(enterGameCounter_ == 0){ getGameSystem()->getSporeStage()->load(); }
		enterGameCounter_--;
	}

	// J̉]
	Camera* camera = getRenderingSystem()->getCamera();
	Vector3 cameraTarget(0.f, 50.f, 0.f);
	Vector3 cameraPosition(0.f, 60.f, 80.f);
	Quaternion quaternion;
	float yRadian = runCounter_ * 0.001f;
	quaternion.setRotationAxis(Vector3::unitY, yRadian);
	cameraPosition = quaternion * cameraPosition;
	camera->setLookAt(cameraPosition, cameraTarget, Vector3::unitY);

	// S̉]
	if(logoNode_ != NULL){ logoNode_->setRotationXYZ(Vector3(0.f, yRadian, 0.f)); }
/*
	// J̑Ώۈʒu
	Vector3 playerPosition = getPlayerSystem()->get(0)->getPosition();
	Vector3 playerRotation = getPlayerSystem()->get(0)->getRotation();
	Vector3 lookAtPosition = playerPosition;
	lookAtPosition.y += 10.f;

	GamePad* pad = getGamePad();
	if(pad != NULL){
		if(pad->buttonDown(GamePad::buttonL1) ||
			pad->buttonDown(GamePad::buttonL2) ||
			pad->buttonDown(GamePad::buttonR1) ||
			pad->buttonDown(GamePad::buttonR2)){
			cameraTargetRotation_ = playerRotation;
		}
	}
	if(getMouse()->buttonDown(2)){
		cameraTargetRotation_ = playerRotation;
	}

	// Jʒu
	Vector3 cameraDistance(0.f, 30.f, -50.f);
	Matrix33 matrix;
	matrix.setRotationXYZ(cameraTargetRotation_);
	cameraTargetPosition_ = playerPosition + matrix * cameraDistance;
	Vector3 cameraPosition = camera->getPosition();
	cameraPosition = cameraTargetPosition_ * 0.1f + cameraPosition * 0.9f;
	camera->setLookAt(cameraPosition, lookAtPosition, Vector3::unitY);

	// Cgʒu̐ݒ
	Vector3 lightPosition = lookAtPosition * 0.7f + cameraPosition * 0.3f;
	lightPosition.y += 10.f;
	lightNode_->setTranslation(lightPosition);
*/
	runCounter_++;
}
//------------------------------------------------------------------------------
// `揀
//------------------------------------------------------------------------------
// `揀
void TitleTask::renderSetup(){
	// V[̃go[X
	getRenderingSystem()->traverse();

	// _O
	getRenderingSystem()->renderingSetup();

}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// `
void TitleTask::render(){
	// wiNA
	getRenderingSystem()->clearBackground();

	// _O
	getRenderingSystem()->rendering();
}
//------------------------------------------------------------------------------
