//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * EqXe[Wwb_
 * @author Junpee
 */

#ifndef SPORE_STAGE_H_
#define SPORE_STAGE_H_

#include "Stage/System/Stage.h"

//------------------------------------------------------------------------------
/**
 * EqXe[W
 */
class SporeStage : public Stage{
friend class GameSystem;
public:
	//--------------------------------------------------------------------------
	// [h
	//--------------------------------------------------------------------------
	/**
	 * [h
	 */
	virtual void load();

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	SporeStage();

	/**
	 * fXgN^
	 */
	virtual ~SporeStage();

	//--------------------------------------------------------------------------
	// An
	//--------------------------------------------------------------------------
	/**
	 * 
	 */
	virtual void initialize();

	/**
	 * n
	 */
	virtual void finalize();

	//--------------------------------------------------------------------------
	// s
	//--------------------------------------------------------------------------
	/**
	 * s
	 */
	virtual void run();

	/**
	 * J
	 */
	virtual void cameraControl();

	//--------------------------------------------------------------------------
	// `揀
	//--------------------------------------------------------------------------
	/**
	 * `揀
	 */
	virtual void renderSetup();

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * `
	 */
	virtual void render();

private:
	//--------------------------------------------------------------------------
	// fobOJtO
	bool debugCamera_;
	// RW`tO
	bool drawCollision_;
	// BGM
	StreamSound* bgm_;
	// V[m[h
	SceneNode* sceneNode_;
	// Cgm[h
	SceneNode* lightNode_;
	// RWm[h
	CollisionNode* collisionNode_;

	// J^[Qbgʒu
	Vector3 cameraTargetPosition_;
	// J^[Qbg]
	Vector3 cameraTargetRotation_;

	// Q[I[oJE^
	int gameOverCounter_;

	// Q[W
	Sprite* gauge_[3];
	// Ct
	Sprite* life_[3];
	// XRA
	Sprite* score_[4];
	// Q[I[o[
	Sprite* gameOver_;

};

//------------------------------------------------------------------------------
#endif // End of SPORE_STAGE_H_
//------------------------------------------------------------------------------
