//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * vCVXewb_
 * @author Junpee
 */

#ifndef PLAYER_SYSTEM_H_
#define PLAYER_SYSTEM_H_

#include "Player/System/Player.h"
#include "Game/System/SystemReference.h"

class Stage;

//------------------------------------------------------------------------------
/**
 * vCVXe
 */
class PlayerSystem : public SystemReference{
friend class GameSystem;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X̎擾
	 * @return CX^X
	 */
	static PlayerSystem* getInstance(){ return instance_; }

	//--------------------------------------------------------------------------
	// [h
	//--------------------------------------------------------------------------
	/**
	 * [h
	 * @param type vC[^Cv
	 */
	virtual void load(Player::Type type);

	//--------------------------------------------------------------------------
	/**
	 * s
	 */
	virtual void run();

	//--------------------------------------------------------------------------
	// vC
	//--------------------------------------------------------------------------
	/**
	 * vC̍쐬
	 * @param type vC[^Cv
	 */
	virtual Player* create(Player::Type type);

	/**
	 * vC̔j
	 * @param player jvC
	 */
	virtual void destroy(Player* player);

	/**
	 * vC̃NA
	 */
	virtual void clear();

	/**
	 * vC̎擾
	 * @return vC
	 */
	virtual int getCount() const{ return players_.getCount(); }

	/**
	 * vC̎擾
	 * @param index vCCfbNX
	 * @return vC
	 */
	virtual Player* get(int index){ return players_[index]; }

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	PlayerSystem();

	/**
	 * fXgN^
	 */
	virtual ~PlayerSystem();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	PlayerSystem(const PlayerSystem& copy);

	// Rs[̉B
	void operator =(const PlayerSystem& copy);

	//--------------------------------------------------------------------------
	// vC
	ArrayList<Player*> players_;
	// vCm[h
	SceneNode* playerNode_;

	// CX^X
	static PlayerSystem* instance_;
};

//------------------------------------------------------------------------------
#endif // End of PLAYER_SYSTEM_H_
//------------------------------------------------------------------------------
