//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * vCVXe
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/System/PlayerSystem.h"
#include "Player/Anzu/Anzu.h"

// CX^X
PlayerSystem* PlayerSystem::instance_ = NULL;

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
PlayerSystem::PlayerSystem() : playerNode_(NULL){
	// CX^X|C^ݒ
	Assert(instance_ == NULL);
	instance_ = this;
}
//------------------------------------------------------------------------------
// fXgN^
PlayerSystem::~PlayerSystem(){
	Assert(getCount() == 0);

	// CX^X|C^n
	Assert(instance_ == this);
	instance_ = NULL;
}
//------------------------------------------------------------------------------
// [h
//------------------------------------------------------------------------------
// [h
void PlayerSystem::load(Player::Type type){
	// vCm[h΍쐬
	if(playerNode_ == NULL){
		// vCm[h̓[gm[hɘAĂȂ
		playerNode_ =
			getScene()->getSceneNodeManager()->createSceneNode("PlayerNode");
	}
	// vC̃[h
	if(type == Player::typeAnzu){
		Anzu::load(playerNode_);
	}else{
		ErrorOut("PlayerSystem::load() ΉĂȂ^Cvł %d", type);
	}
}
//------------------------------------------------------------------------------
// s
void PlayerSystem::run(){
	int count = getCount();
	for(int i = 0; i < count; i++){ get(i)->run(); }
}
//------------------------------------------------------------------------------
// vC
//------------------------------------------------------------------------------
// vC̍쐬
Player* PlayerSystem::create(Player::Type type){
	Player* player = NULL;
	if(type == Player::typeAnzu){
		player = new Anzu();
		players_.add(player);
	}else{
		ErrorOut("PlayerSystem::load() ΉĂȂ^Cvł %d", type);
	}
	return player;
}
//------------------------------------------------------------------------------
// vC̔j
void PlayerSystem::destroy(Player* player){
	int result = players_.removeByValue(player);
	Assert(result != -1);
	delete player;
}
//------------------------------------------------------------------------------
// vC̃NA
void PlayerSystem::clear(){
	for(int i = getCount() - 1; i >= 0; i--){ delete get(i); }
	players_.clear();
	// vCm[h̔j
	if(playerNode_ != NULL){
		SceneNode::recursiveDestroy(playerNode_);
		playerNode_ = NULL;
	}
}
//------------------------------------------------------------------------------
