//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * vCԃwb_
 * @author Junpee
 */

#ifndef PLAYER_STATE_H_
#define PLAYER_STATE_H_

#include "Game/System/SystemReference.h"

class Stage;

//------------------------------------------------------------------------------
/**
 * vC
 */
class PlayerState : public SystemReference{
friend class Player;
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param player vC
	 */
	PlayerState(Player* player);

	/**
	 * fXgN^
	 */
	virtual ~PlayerState();

	//--------------------------------------------------------------------------
	/**
	 * _[WXe[g
	 * @param _[WXe[gȂtrue
	 */
	virtual bool isDamageState() const{ return false; }

	/**
	 * SXe[g
	 * @param SXe[gȂtrue
	 */
	virtual bool isDeathState() const{ return false; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * vC̎擾
	 * @return vC
	 */
	virtual Player* getPlayer(){ return player_; }

	//--------------------------------------------------------------------------
	// s
	//--------------------------------------------------------------------------
	/**
	 * 
	 */
	virtual void initialize() = 0;

	/**
	 * n
	 */
	virtual void finalize() = 0;

	/**
	 * s
	 */
	virtual void run() = 0;

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ړXeBbNl̎擾
	 * @return ړXeBbNl
	 */
	virtual Point2f getMoveStick();

	/**
	 * Wv{^_E
	 * @return Wv{^ꂽtrue
	 */
	virtual bool downJumpButton();

	/**
	 * U{^_E
	 * @return U{^ꂽtrue
	 */
	virtual bool downAttackButton();

	//--------------------------------------------------------------------------
	// V[m[h
	//--------------------------------------------------------------------------
	/**
	 * V[m[h̎擾
	 * @return V[m[h
	 */
	virtual SceneNode* getSceneNode();

	//--------------------------------------------------------------------------
	// f
	//--------------------------------------------------------------------------
	/**
	 * f̎擾
	 * @return f
	 */
	virtual CharacterModel* getModel();

	/**
	 * E{[̎擾
	 * @return E{[
	 */
	virtual Bone* getRightHandBone();

	/**
	 * ̃{[̎擾
	 * @return ̃{[
	 */
	virtual Bone* getBodyBone();

	//--------------------------------------------------------------------------
	// Aj[V
	//--------------------------------------------------------------------------
	/**
	 * Aj[V̎擾
	 * @return Aj[V
	 */
	virtual Animation* getAnimation();

	//--------------------------------------------------------------------------
	// RW
	//--------------------------------------------------------------------------
	/**
	 * RWm[h̎擾
	 * @return RWm[h
	 */
	virtual CollisionNode* getCollisionNode();

	/**
	 * n`RW̎擾
	 * @return n`RW
	 */
	virtual StaticSphereCollision* getLandCollision();

	/**
	 * _[WRW̎擾
	 * @return _[WRW
	 */
	virtual StaticSphereCollision* getDamageCollision();

	/**
	 * URW̎擾
	 * @return URW
	 */
	virtual StaticSphereCollision* getAttackCollision();

	//--------------------------------------------------------------------------
	// ʒu
	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param position ʒu
	 */
	virtual void setPosition(const Vector3& position);

	/**
	 * ʒu̎擾
	 * @return ʒu
	 */
	virtual const Vector3& getPosition() const;

	//--------------------------------------------------------------------------
	// ]
	//--------------------------------------------------------------------------
	/**
	 * ̐ݒ
	 * @param direction 
	 */
	virtual void setDirection(const Vector3& direction);

	/**
	 * ̎擾
	 * @return 
	 */
	virtual const Vector3& getDirection() const;

	/**
	 * ]̎擾
	 * @return ]
	 */
	virtual const Vector3& getRotation() const;

	//--------------------------------------------------------------------------
	// x
	//--------------------------------------------------------------------------
	/**
	 * x̐ݒ
	 * @param velocity x
	 */
	virtual void setVelocity(const Vector3& velocity);

	/**
	 * x̎擾
	 * @return x
	 */
	virtual const Vector3& getVelocity() const;

	//--------------------------------------------------------------------------
	// 󒆃tO
	//--------------------------------------------------------------------------
	/**
	 * 󒆃tO̐ݒ
	 * @param isAerial 󒆂Ȃtrue
	 */
	virtual void setAerial(bool isAerial);

	/**
	 * 󒆃tO̎擾
	 * @return 󒆂Ȃtrue
	 */
	virtual bool isAerial() const;

	//--------------------------------------------------------------------------
	// Ct
	//--------------------------------------------------------------------------
	/**
	 * ̐ݒ
	 * @param life 
	 */
	virtual void setLife(int life);

	/**
	 * ̎擾
	 * @return 
	 */
	virtual int getLife() const;

	/**
	 * ̗͂̐ݒ
	 * @param health ̗
	 */
	virtual void setHealth(int health);

	/**
	 * ̗͂̎擾
	 * @return ̗
	 */
	virtual int getHealth() const;

	/**
	 * ł邩
	 * @return łȂtrue
	 */
	virtual bool isDeath() const;

	/**
	 * SłĂ邩
	 * @return SłĂtrue
	 */
	virtual bool isAnnihilated() const;

	//--------------------------------------------------------------------------
	// _[W
	//--------------------------------------------------------------------------
	/**
	 * _[W̎擾
	 * @return _[W
	 */
	virtual const Vector3& getDamageDirection() const;

	/**
	 * _[Wl̎擾
	 * @return _[Wl
	 */
	virtual int getDamageValue() const;

	/**
	 * _[W̃NA
	 */
	virtual void clearDamage();

	/**
	 * GJE^̎擾
	 * @return GJE^
	 */
	virtual int getMatchlessCounter() const;

	/**
	 * GJE^̐ݒ
	 * @param matchlessCounter GJE^
	 */
	virtual void setMatchlessCounter(int matchlessCounter);

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	PlayerState(const PlayerState& copy);

	// Rs[̉B
	void operator =(const PlayerState& copy);

	//--------------------------------------------------------------------------
	// vC
	Player* player_;

};

//------------------------------------------------------------------------------
#endif // End of PLAYER_STATE_H_
//------------------------------------------------------------------------------

