//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * vCԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/System/PlayerState.h"
#include "Player/System/Player.h"
#include "Game/Input/GamePad.h"

#include "Game/Rendering/RenderingSystem.h"

//------------------------------------------------------------------------------
// RXgN^
PlayerState::PlayerState(Player* player) : SystemReference(), player_(player){
}
//------------------------------------------------------------------------------
// fXgN^
PlayerState::~PlayerState(){
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// ړXeBbNl̎擾
Point2f PlayerState::getMoveStick(){
	GamePad* pad = getGamePad();
	Point2f move(Point2f::zero);
	if(pad != NULL){ move += pad->getLeftAxis(); }
//*
	if(getKeyboard()->pressed(Keyboard::keyE)){ move.y -= 1.f; }
	if(getKeyboard()->pressed(Keyboard::keyD)){ move.y += 1.f; }
	if(getKeyboard()->pressed(Keyboard::keyS)){ move.x -= 1.f; }
	if(getKeyboard()->pressed(Keyboard::keyF)){ move.x += 1.f; }
/*/
	if(getKeyboard()->pressed(Keyboard::keyW)){ move.y -= 1.f; }
	if(getKeyboard()->pressed(Keyboard::keyS)){ move.y += 1.f; }
	if(getKeyboard()->pressed(Keyboard::keyA)){ move.x -= 1.f; }
	if(getKeyboard()->pressed(Keyboard::keyD)){ move.x += 1.f; }
//*/
	if(getKeyboard()->pressed(Keyboard::keyUp)){ move.y -= 1.f; }
	if(getKeyboard()->pressed(Keyboard::keyDown)){ move.y += 1.f; }
	if(getKeyboard()->pressed(Keyboard::keyLeft)){ move.x -= 1.f; }
	if(getKeyboard()->pressed(Keyboard::keyRight)){ move.x += 1.f; }

	Vector3 vector(move.x, 0.f, move.y);
	if(vector.isZero()){ return Point2f::zero; }
	vector.normalize();

	Camera* camera = getRenderingSystem()->getCamera();
	Vector3 rotation = camera->getRotation();
	Matrix33 matrix;
	matrix.setRotationXYZ(rotation);
	vector = matrix * vector;

	return Point2f(vector.x, vector.z);
}
//------------------------------------------------------------------------------
// Wv{^_E
bool PlayerState::downJumpButton(){
	bool result = false;
	GamePad* pad = getGamePad();
	if(pad != NULL){
		result |= pad->buttonDown(GamePad::buttonMaru);
		result |= pad->buttonDown(GamePad::buttonBatu);
	}
	result |= getMouse()->buttonDown(1);
	result |= getKeyboard()->down(Keyboard::keyK);
	result |= getKeyboard()->down(Keyboard::keyX);
	return result;
}
//------------------------------------------------------------------------------
// U{^_E
bool PlayerState::downAttackButton(){
	bool result = false;
	GamePad* pad = getGamePad();
	if(pad != NULL){
		result |= pad->buttonDown(GamePad::buttonSankaku);
		result |= pad->buttonDown(GamePad::buttonSikaku);
	}
	result |= getMouse()->buttonDown(0);
	result |= getKeyboard()->down(Keyboard::keyC);
	result |= getKeyboard()->down(Keyboard::keyJ);
	return result;
}
//------------------------------------------------------------------------------
// V[m[h
//------------------------------------------------------------------------------
// V[m[h̎擾
SceneNode* PlayerState::getSceneNode(){
	return player_->getSceneNode();
}
//------------------------------------------------------------------------------
// f
//------------------------------------------------------------------------------
// f̎擾
CharacterModel* PlayerState::getModel(){
	return player_->getModel();
}
//------------------------------------------------------------------------------
// E{[̎擾
Bone* PlayerState::getRightHandBone(){
	return player_->getRightHandBone();
}
//------------------------------------------------------------------------------
// ̃{[̎擾
Bone* PlayerState::getBodyBone(){
	return player_->getBodyBone();
}
//------------------------------------------------------------------------------
// Aj[V
//------------------------------------------------------------------------------
// Aj[V̎擾
Animation* PlayerState::getAnimation(){
	return player_->getAnimation();
}
//------------------------------------------------------------------------------
// RW
//------------------------------------------------------------------------------
// RWm[h̎擾
CollisionNode* PlayerState::getCollisionNode(){
	return player_->getCollisionNode();
}
//------------------------------------------------------------------------------
// n`RW̎擾
StaticSphereCollision* PlayerState::getLandCollision(){
	return player_->getLandCollision();
}
//------------------------------------------------------------------------------
// _[WRW̎擾
StaticSphereCollision* PlayerState::getDamageCollision(){
	return player_->getDamageCollision();
}
//------------------------------------------------------------------------------
// URW̎擾
StaticSphereCollision* PlayerState::getAttackCollision(){
	return player_->getAttackCollision();
}
//------------------------------------------------------------------------------
// ʒu
//------------------------------------------------------------------------------
// ʒu̐ݒ
void PlayerState::setPosition(const Vector3& position){
	player_->setPosition(position);
}
//------------------------------------------------------------------------------
// ʒu̎擾
const Vector3& PlayerState::getPosition() const{
	return player_->getPosition();
}
//------------------------------------------------------------------------------
// ]
//------------------------------------------------------------------------------
// ̐ݒ
void PlayerState::setDirection(const Vector3& direction){
	player_->setDirection(direction);
}
//------------------------------------------------------------------------------
// ̎擾
const Vector3& PlayerState::getDirection() const{
	return player_->getDirection();
}
//------------------------------------------------------------------------------
// ]̎擾
const Vector3& PlayerState::getRotation() const{
	return player_->getRotation();
}
//------------------------------------------------------------------------------
// x
//------------------------------------------------------------------------------
// x̐ݒ
void PlayerState::setVelocity(const Vector3& velocity){
	player_->setVelocity(velocity);
}
//------------------------------------------------------------------------------
// x̎擾
const Vector3& PlayerState::getVelocity() const{
	return player_->getVelocity();
}
//------------------------------------------------------------------------------
// 󒆃tO
//------------------------------------------------------------------------------
// 󒆃tO̐ݒ
void PlayerState::setAerial(bool isAerial){
	player_->setAerial(isAerial);
}
//------------------------------------------------------------------------------
// 󒆃tO̎擾
bool PlayerState::isAerial() const{
	return player_->isAerial();
}
//------------------------------------------------------------------------------
// Ct
//------------------------------------------------------------------------------
// ̐ݒ
void PlayerState::setLife(int life){
	player_->setLife(life);
}
//------------------------------------------------------------------------------
// ̎擾
int PlayerState::getLife() const{
	return player_->getLife();
}
//------------------------------------------------------------------------------
// ̗͂̐ݒ
void PlayerState::setHealth(int health){
	player_->setHealth(health);
}
//------------------------------------------------------------------------------
// ̗͂̎擾
int PlayerState::getHealth() const{
	return player_->getHealth();
}
//------------------------------------------------------------------------------
// ł邩
bool PlayerState::isDeath() const{
	return player_->isDeath();
}
//------------------------------------------------------------------------------
// SłĂ邩
bool PlayerState::isAnnihilated() const{
	return player_->isAnnihilated();
}
//------------------------------------------------------------------------------
// _[W
//------------------------------------------------------------------------------
// _[W̎擾
const Vector3& PlayerState::getDamageDirection() const{
	return player_->getDamageDirection();
}
//------------------------------------------------------------------------------
// _[Wl̎擾
int PlayerState::getDamageValue() const{
	return player_->getDamageValue();
}
//------------------------------------------------------------------------------
// _[W̃NA
void PlayerState::clearDamage(){
	player_->clearDamage();
}
//------------------------------------------------------------------------------
// GJE^̎擾
int PlayerState::getMatchlessCounter() const{
	return player_->getMatchlessCounter();
}
//------------------------------------------------------------------------------
// GJE^̐ݒ
void PlayerState::setMatchlessCounter(int matchlessCounter){
	player_->setMatchlessCounter(matchlessCounter);
}
//------------------------------------------------------------------------------
