//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * vC
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/System/Player.h"
#include "Player/System/PlayerState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
Player::Player() : sceneNode_(NULL), model_(NULL),
	rightHandBone_(NULL), bodyBone_(NULL), animation_(NULL),
	collisionNode_(NULL), landCollision_(NULL), damageCollision_(NULL),
	attackCollision_(NULL),
	state_(NULL), nextState_(NULL),
	position_(Vector3::zero), rotation_(Vector3::zero),
	direction_(Vector3::unitZ),
	velocity_(Vector3::zero), isAerial_(true),
	life_(3), health_(500),
	damageDirection_(Vector3::zero), damageValue_(0), matchlessCounter_(0){
}
//------------------------------------------------------------------------------
// fXgN^
Player::~Player(){
	if(nextState_ != NULL){ SafeDelete(nextState_); }
	if(state_ != NULL){
		state_->finalize();
		delete state_;
	}
	// RWm[h̔j
	CollisionNode::recursiveDestroy(getCollisionNode());
	// V[m[h̔j
	SceneNode::recursiveDestroy(getSceneNode());
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// f̏
SceneNode* Player::initializeModel(const String& name){
	// ff[^̕
	SceneNode* nodeSource = getScene()->getSceneNodeManager()->search(name);
	Assert(nodeSource != NULL);
	sceneNode_ = nodeSource->copy();
	getScene()->getRootNode()->addSceneNode(sceneNode_);
	// f
	model_ = sceneNode_->getSceneLeaf(0)->castModel()->castCharacterModel();
	Assert(model_ != NULL);
	// E{[擾
	rightHandBone_ = model_->searchBone("TekubiR");
	Assert(rightHandBone_ != NULL);
	// ̃{[擾
	bodyBone_ = model_->searchBone("Kosi");
	Assert(bodyBone_ != NULL);
	return sceneNode_;
}
//------------------------------------------------------------------------------
// Aj[V̏
Animation* Player::initializeAnimation(const String& name){
	// Aj[ṼRs[
	Animation* animationSource = getAnimationManager()->search(name);
	Assert(animationSource != NULL);
	animation_ = animationSource->copy();

	// oCh
	AnimationSet* animationSet = animation_->castAnimationSet();
	Assert(animationSet != NULL);
	Assert(animationSet->getAnimationCount() == 1);
	CharacterModelAnimation* modelAnimation =
		animationSet->getAnimation(0)->castCharacterModelAnimation();
	Assert(modelAnimation != NULL);
	modelAnimation->bind(model_);
	return animation_;
}
//------------------------------------------------------------------------------
// RW̏
CollisionNode* Player::initializeCollision(const String& name,
	float landSize, float damageSize){
	String fixedName = getCollisionScene()->renameNode(name);
	// m[h̏
	collisionNode_ = getCollisionScene()->createCollisionNode(fixedName);
	getCollisionScene()->getRootNode()->addChild(collisionNode_);
	// n`RW̏
	landCollision_ =
		getCollisionScene()->createStaticSphereCollision(fixedName + "Land");
	landCollision_->setSphere(Vector3(0.f, landSize, 0.f), landSize);
	landCollision_->setCollisionMask(1);
	landCollision_->setUserData(this);
	collisionNode_->addChild(landCollision_);
	// _[WRW̏
	damageCollision_ =
		getCollisionScene()->createStaticSphereCollision(fixedName + "Damage");
	damageCollision_->setSphere(Vector3(0.f, landSize, 0.f), damageSize);
	damageCollision_->setCollisionMask(2);
	damageCollision_->setUserData(this);
	collisionNode_->addChild(damageCollision_);
	// URW̏
	attackCollision_ =
		getCollisionScene()->createStaticSphereCollision(fixedName + "Attack");
	attackCollision_->setCollisionMask(0);
	attackCollision_->setEnabled(false);
	attackCollision_->setUserData(this);
	collisionNode_->addChild(attackCollision_);
	return collisionNode_;
}
//------------------------------------------------------------------------------
// Ԃ̐ݒ
void Player::setState(PlayerState* state){
	if(nextState_ != NULL){ SafeDelete(nextState_); }
	nextState_ = state;
}
//------------------------------------------------------------------------------
// s
void Player::run(){
	if(nextState_ != NULL){
		if(state_ != NULL){
			state_->finalize();
			delete state_;
		}
		state_ = nextState_;
		nextState_ = NULL;
		state_->initialize();
	}
	if(state_ != NULL){ state_->run(); }
}
//------------------------------------------------------------------------------
// ̐ݒ
void Player::setDirection(const Vector3& direction){
	if(direction.isZero()){ return; }
	direction_ = direction;
	direction_.normalize();
	rotation_ = Math3D::lookAtZ(direction_);
}
//------------------------------------------------------------------------------
