//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AYԃwb_
 * @author Junpee
 */

#ifndef ANZU_STATE_H_
#define ANZU_STATE_H_

#include "Player/System/PlayerState.h"

class Anzu;

//------------------------------------------------------------------------------
/**
 * AY
 */
class AnzuState : public PlayerState{
friend class Anzu;
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param anzu AY
	 */
	AnzuState(Anzu* anzu);

	/**
	 * fXgN^
	 */
	virtual ~AnzuState();

protected:
	//--------------------------------------------------------------------------
	/**
	 * AY̎擾
	 * @return AY
	 */
	virtual Anzu* getAnzu(){ return anzu_; }

	/**
	 * P̎擾
	 * @return P
	 */
	virtual SceneNode* getUmbrella();

	/**
	 * _[W󂯂
	 * @return _[W󂯂true
	 */
	virtual bool isDamaged();

	/**
	 * xƈʒǔvZ
	 * @param addVelocity ǉ鑬x
	 */
	virtual void calcVelocityAndPosition(Vector3 addVelocity = Vector3::zero);

	/**
	 * n`RW
	 */
	virtual void landCollide();

	/**
	 * URW
	 * @param bone {[
	 * @param offset RW̃ItZbg
	 * @param size RW̃TCY
	 * @param damage RW̃_[W
	 */
	virtual void attackCollide(
		Bone* bone, const Vector3& offset, float size, int damage);

	/**
	 * `ZbgAbv
	 * @param animationTime Aj[V
	 */
	virtual void drawSetup(	float animationTime);

private:
	//--------------------------------------------------------------------------
	// AY
	Anzu* anzu_;

};

//------------------------------------------------------------------------------
#endif // End of ANZU_STATE_H_
//------------------------------------------------------------------------------

