//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AYԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/Anzu/AnzuState.h"
#include "Player/Anzu/Anzu.h"

#include "Stage/System/Stage.h"
#include "Player/Anzu/AnzuBigDamageState.h"
#include "Player/Anzu/AnzuSmallDamageState.h"

#include "Enemy/System/EnemySystem.h"
#include "Enemy/System/Enemy.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AnzuState::AnzuState(Anzu* anzu) : PlayerState(anzu), anzu_(anzu){
}
//------------------------------------------------------------------------------
// fXgN^
AnzuState::~AnzuState(){
}
//------------------------------------------------------------------------------
// P̎擾
SceneNode* AnzuState::getUmbrella(){
	return anzu_->getUmbrella();
}
//------------------------------------------------------------------------------
// _[W󂯂
bool AnzuState::isDamaged(){
	// GJE^
	int matchlessCounter = getMatchlessCounter();
	if(matchlessCounter > 0){
		matchlessCounter--;
		setMatchlessCounter(matchlessCounter);
		clearDamage();
		return false;
	}
	// _[W
	int damageValue = getDamageValue();
	// GJE^̐ݒ̓_[WXe[gɂčs
	if(damageValue == 0){ return false; }

	// _[W
	if(isAerial()){ damageValue *= 2; }
	setHealth(getHealth() - damageValue);

	// S󒆂傫_[WȂ琁
	if(isDeath() || isAerial() || (damageValue > 50)){
		getPlayer()->setState(new AnzuBigDamageState(getAnzu()));
	}else{
		getPlayer()->setState(new AnzuSmallDamageState(getAnzu()));
	}
	return true;
}
//------------------------------------------------------------------------------
// xƈʒǔvZ
void AnzuState::calcVelocityAndPosition(Vector3 addVelocity){
	float velocityXZAttenuation = 0.6f;
	float velocityYAttenuation = 0.95f;
	Vector3 forceField(0.f, -0.1f, 0.f);
	Vector3 position = getPosition();
	Vector3 velocity = getVelocity();

	velocity += forceField;
	velocity += addVelocity;
	velocity.x *= velocityXZAttenuation;
	velocity.y *= velocityYAttenuation;
	velocity.z *= velocityXZAttenuation;
	position += velocity;
	// vZʂ̐ݒ
	setPosition(position);
	setVelocity(velocity);
}
//------------------------------------------------------------------------------
// n`RW
void AnzuState::landCollide(){
	// RW[vARecőΉ΍ő3
	Vector3 position = getPosition();
	Vector3 velocity = getVelocity();
	CollisionNode* collisionNode = getCollisionNode();
	collisionNode->setRotationXYZ(getRotation());

	for(int i = 0; i < 3; i++){
		// RẄʒuݒ
		collisionNode->setTranslation(position);
		collisionNode->traverse();

		// n`Ƃ̃RW
		IntersectionResult result;
		getCollisionScene()->intersection(&result, getLandCollision(), 1);

		if(!result.isIntersected()){ break; }

		// ˃xNg␳
		Vector3 refrection = result.getMaxRefrection();
		if(Math::abs(refrection.x) < 0.09f){ refrection.x = 0.f; }
		if(Math::abs(refrection.z) < 0.09f){ refrection.z = 0.f; }
		if(refrection.isZero()){ break; }

		// ʒu␳
		position += refrection;
		// x␳
		if(refrection.y > 0.f){
			setAerial(false);
			velocity.y = 0.f;
		}
	}
	// RWʒuݒ
	collisionNode->setTranslation(position);
	collisionNode->traverse();

	// vZʂ̐ݒ
	setPosition(position);
	setVelocity(velocity);
}
//------------------------------------------------------------------------------
// URW
void AnzuState::attackCollide(
	Bone* bone, const Vector3& offset, float size, int damage){
	// RẄʒu킹
	getModel()->buildBoneMatrix();
	StaticSphereCollision* collision = getAttackCollision();
	collision->setSphere(bone->getModelMatrix() * offset, size);

	// U
	collision->traverse();
	Sphere attack = collision->getWorldSphere();
	int count = getEnemySystem()->getCount();
	for(int i = 0; i < count; i++){
		Enemy* enemy = getEnemySystem()->get(i);
		Sphere target = enemy->getDamageCollision()->getWorldSphere();
		Intersection intersection;
		if(attack.intersect(&intersection, target)){
			enemy->damage(enemy->getPosition() - getPosition(), damage);
		}
	}
}
//------------------------------------------------------------------------------
// `ZbgAbv
void AnzuState::drawSetup(float animationTime){
	// `ʒuݒ
	SceneNode* sceneNode = getSceneNode();
	sceneNode->setTranslation(getPosition());
	sceneNode->setRotationXYZ(getRotation());
	sceneNode->traverse();

	// Aj[V
	getAnimation()->animate(animationTime, Animation::maskPostCulling);

	// P̈ʒu킹
	getModel()->buildBoneMatrix();
	const Matrix34& matrix = getRightHandBone()->getModelMatrix();
	getUmbrella()->setTranslation(matrix.getTranslation());
	getUmbrella()->setRotationQuaternion(matrix.getRotationQuaternion());
}
//------------------------------------------------------------------------------
