//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AYԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/Anzu/AnzuStandState.h"
#include "Player/System/Player.h"
#include "Stage/System/Stage.h"

#include "Player/Anzu/AnzuRunState.h"
#include "Player/Anzu/AnzuJumpState.h"
#include "Player/Anzu/AnzuAttackState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AnzuStandState::AnzuStandState(Anzu* anzu) : AnzuState(anzu){
}
//------------------------------------------------------------------------------
// fXgN^
AnzuStandState::~AnzuStandState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void AnzuStandState::initialize(){
	// Aj[VV[PXݒ
	getAnimation()->setSequence(0);
}
//------------------------------------------------------------------------------
// n
void AnzuStandState::finalize(){
}
//------------------------------------------------------------------------------
// s
void AnzuStandState::run(){
	// 萔
	float animationScale = 1.f;

	// Xe[gύX
	Point2f moveStick = getMoveStick();
	if(!isDamaged()){
		if(downAttackButton()){
			getPlayer()->setState(new AnzuAttackState(getAnzu()));
		}else if(downJumpButton()){
			getPlayer()->setState(new AnzuJumpState(getAnzu(), false));
		}else if(moveStick != Point2f::zero){
			getPlayer()->setState(new AnzuRunState(getAnzu()));
		}
	}

	// ʒuƑx̌vZ
	calcVelocityAndPosition();

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);
}
//------------------------------------------------------------------------------
