//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AY_[WԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/Anzu/AnzuSmallDamageState.h"
#include "Game/Sound/SoundSystem.h"
#include "Player/System/Player.h"

#include "Player/Anzu/AnzuRunState.h"
#include "Player/Anzu/AnzuStandState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AnzuSmallDamageState::AnzuSmallDamageState(Anzu* anzu) : AnzuState(anzu){
}
//------------------------------------------------------------------------------
// fXgN^
AnzuSmallDamageState::~AnzuSmallDamageState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void AnzuSmallDamageState::initialize(){
	// ̐ݒ
	Vector3 direction = -getDamageDirection();
	direction.y = 0.f;
	setDirection(direction);
	clearDamage();
	// Aj[VV[PXݒ
	getAnimation()->setSequence(3);
	// sJE^NA
	runCounter_ = 0;
	// Ƒx̏
	setVelocity(getDirection() * -1.f);
	// 炷
	getSoundSystem()->play("AnzuSmallDamage");
}
//------------------------------------------------------------------------------
// n
void AnzuSmallDamageState::finalize(){
	// GJE^ݒ
	setMatchlessCounter(60);
}
//------------------------------------------------------------------------------
// s
void AnzuSmallDamageState::run(){
	// 萔
	float animationScale = 1.f;

	// Xe[gύX
	if(runCounter_ == 30){
		Point2f moveStick = getMoveStick();
		if(moveStick != Point2f::zero){
			getPlayer()->setState(new AnzuRunState(getAnzu()));
		}else{
			getPlayer()->setState(new AnzuStandState(getAnzu()));
		}
	}

	// ʒuƑx̌vZ
	calcVelocityAndPosition(getDirection() * -0.1f);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);

	// sJE^CNg
	runCounter_++;
}
//------------------------------------------------------------------------------
