//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AYԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/Anzu/AnzuRunState.h"
#include "Game/Sound/SoundSystem.h"
#include "Player/System/Player.h"
#include "Stage/System/Stage.h"

#include "Player/Anzu/AnzuStandState.h"
#include "Player/Anzu/AnzuJumpState.h"
#include "Player/Anzu/AnzuAttackState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AnzuRunState::AnzuRunState(Anzu* anzu) : AnzuState(anzu){
}
//------------------------------------------------------------------------------
// fXgN^
AnzuRunState::~AnzuRunState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void AnzuRunState::initialize(){
	// Aj[VV[PXݒ
	getAnimation()->setSequence(1);
	// JE^
	footstepCounter_ = 20.f;
}
//------------------------------------------------------------------------------
// n
void AnzuRunState::finalize(){
}
//------------------------------------------------------------------------------
// s
void AnzuRunState::run(){
	Assert(!isAerial());
	// 萔
	float animationScale = 4.f;
	float moveXZScale = 0.5f;

	// Xe[gύX
	Point2f moveStick = getMoveStick();
	Vector3 moveVelocity(moveStick.x, 0.f, moveStick.y);
	if(!isDamaged()){
		if(downAttackButton()){
			getPlayer()->setState(new AnzuAttackState(getAnzu()));
		}else if(downJumpButton()){
			getPlayer()->setState(new AnzuJumpState(getAnzu(), false));
		}else if(moveVelocity.isZero()){
			getPlayer()->setState(new AnzuStandState(getAnzu()));
		}
	}

	// ړxNgZo
	moveVelocity *= moveXZScale;

	// Aj[Vx
	animationScale *= moveVelocity.getLength();

	// 炷
	footstepCounter_ += animationScale;
	if(footstepCounter_ > 30.f){
		getSoundSystem()->play("AnzuAsioto", 0.5f);
		footstepCounter_ = 0.f;
	}

	// ʒuƑx̌vZ
	calcVelocityAndPosition(moveVelocity);
	// ̐ݒ
	setDirection(moveVelocity);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);
}
//------------------------------------------------------------------------------
