//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AYWvԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/Anzu/AnzuJumpState.h"
#include "Game/Sound/SoundSystem.h"
#include "Player/System/Player.h"
#include "Stage/System/Stage.h"

#include "Player/Anzu/AnzuStandState.h"
#include "Player/Anzu/AnzuRunState.h"
#include "Player/Anzu/AnzuJumpAttackState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AnzuJumpState::AnzuJumpState(Anzu* anzu, bool doubleJump) :
	AnzuState(anzu), isDoubleJump_(doubleJump){
}
//------------------------------------------------------------------------------
// fXgN^
AnzuJumpState::~AnzuJumpState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void AnzuJumpState::initialize(){
	// Aj[VV[PXݒ
	getAnimation()->setSequence(6);
	// Wvxݒ
	float jumpVelocity = 3.f;
	setVelocity(getVelocity() + Vector3(0.f, jumpVelocity, 0.f));
	setAerial(true);
	// Wv炷
	getSoundSystem()->play("AnzuJump");
}
//------------------------------------------------------------------------------
// n
void AnzuJumpState::finalize(){
}
//------------------------------------------------------------------------------
// s
void AnzuJumpState::run(){
	// 萔
	float animationScale = 1.f;
	float moveXZScale = 0.5f;

	// Xe[gύX
	Point2f moveStick = getMoveStick();
	if(!isDamaged()){
		if(!isAerial()){
			if(moveStick == Point2f::zero){
				getPlayer()->setState(new AnzuStandState(getAnzu()));
			}else{
				getPlayer()->setState(new AnzuRunState(getAnzu()));
			}
		}else if(downAttackButton()){
			getPlayer()->setState(
				new AnzuJumpAttackState(getAnzu(), isDoubleJump_));
		}else if(downJumpButton() && (!isDoubleJump_)){
			getPlayer()->setState(new AnzuJumpState(getAnzu(), true));
		}
	}

	// ړxNgZo
	Vector3 moveVelocity(moveStick.x, 0.f, moveStick.y);
	moveVelocity *= moveXZScale;

	// ʒuƑx̌vZ
	calcVelocityAndPosition(moveVelocity);
	// ̐ݒ
	setDirection(moveVelocity);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);
}
//------------------------------------------------------------------------------
