//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AYWvUԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/Anzu/AnzuJumpAttackState.h"
#include "Game/Sound/SoundSystem.h"
#include "Player/System/Player.h"
#include "Stage/System/Stage.h"

#include "Player/Anzu/AnzuStandState.h"
#include "Player/Anzu/AnzuRunState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AnzuJumpAttackState::AnzuJumpAttackState(Anzu* anzu, bool doubleJump) :
	AnzuState(anzu), isDoubleJump_(doubleJump){
}
//------------------------------------------------------------------------------
// fXgN^
AnzuJumpAttackState::~AnzuJumpAttackState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void AnzuJumpAttackState::initialize(){
	// Aj[VV[PXݒ
	getAnimation()->setSequence(7);
	// WvU炷
	getSoundSystem()->play("AnzuJumpAttack");
	// sJE^NA
	runCounter_ = 0;
}
//------------------------------------------------------------------------------
// n
void AnzuJumpAttackState::finalize(){
	// RW𖳌ɖ߂
	getAttackCollision()->setEnabled(false);
}
//------------------------------------------------------------------------------
// s
void AnzuJumpAttackState::run(){
	// 萔
	float animationScale = 2.f;
	float moveXZScale = 0.5f;

	// Xe[gύX
	Point2f moveStick = getMoveStick();
	if(!isDamaged()){
		if(!isAerial()){
			if(moveStick == Point2f::zero){
				getPlayer()->setState(new AnzuStandState(getAnzu()));
			}else{
				getPlayer()->setState(new AnzuRunState(getAnzu()));
			}
		}
	}

	// ړxNgZo
	Vector3 moveVelocity(moveStick.x, 0.f, moveStick.y);
	moveVelocity *= moveXZScale;

	// ʒuƑx̌vZ
	calcVelocityAndPosition(moveVelocity);
	// ̐ݒ
	setDirection(moveVelocity);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);

	// U
	if(runCounter_ == 10){ getAttackCollision()->setEnabled(true); }
	if(runCounter_ == 22){ getAttackCollision()->setEnabled(false); }
	float range = 9.f;
	if(getAttackCollision()->isEnabled()){
		if(isDoubleJump_){
			attackCollide(getRightHandBone(),
				Vector3(0.f, range, range), range, 400);
		}else{
			attackCollide(getRightHandBone(),
				Vector3(0.f, range, range), range, 200);
		}
	}

	// sJE^CNg
	runCounter_++;
}
//------------------------------------------------------------------------------
