//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AYNオԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/Anzu/AnzuGetUpState.h"
#include "Game/Sound/SoundSystem.h"
#include "Player/System/Player.h"

#include "Player/Anzu/AnzuRunState.h"
#include "Player/Anzu/AnzuStandState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AnzuGetUpState::AnzuGetUpState(Anzu* anzu) : AnzuState(anzu){
}
//------------------------------------------------------------------------------
// fXgN^
AnzuGetUpState::~AnzuGetUpState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void AnzuGetUpState::initialize(){
	// Aj[VV[PXݒ
	getAnimation()->setSequence(5);
	// sJE^NA
	runCounter_ = 0;
	// URWLɂ
	getAttackCollision()->setEnabled(true);
	// 炷
//	getSoundSystem()->play("AnzuGetUp");
}
//------------------------------------------------------------------------------
// n
void AnzuGetUpState::finalize(){
	// URW𖳌ɖ߂
	getAttackCollision()->setEnabled(false);
	// GJE^ݒ
	setMatchlessCounter(60);
}
//------------------------------------------------------------------------------
// s
void AnzuGetUpState::run(){
	// 萔
	float animationScale = 1.f;

	// Xe[gύX
	if(runCounter_ == 60){
		Point2f moveStick = getMoveStick();
		if(moveStick != Point2f::zero){
			getPlayer()->setState(new AnzuRunState(getAnzu()));
		}else{
			getPlayer()->setState(new AnzuStandState(getAnzu()));
		}
	}

	// ʒuƑx̌vZ
	calcVelocityAndPosition(getDirection() * 0.4f);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);

	// U
	attackCollide(getBodyBone(), Vector3(0.f, 0.f, 0.f), 10.f, 20);

	// sJE^CNg
	runCounter_++;
}
//------------------------------------------------------------------------------
