//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AYSԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/Anzu/AnzuDeathState.h"
#include "Game/Sound/SoundSystem.h"
#include "Player/System/Player.h"

#include "Player/Anzu/AnzuGetUpState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AnzuDeathState::AnzuDeathState(Anzu* anzu) : AnzuState(anzu){
}
//------------------------------------------------------------------------------
// fXgN^
AnzuDeathState::~AnzuDeathState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void AnzuDeathState::initialize(){
	// sJE^NA
	runCounter_ = 0;
	// 炷
	getSoundSystem()->play("AnzuDeath");
}
//------------------------------------------------------------------------------
// n
void AnzuDeathState::finalize(){
}
//------------------------------------------------------------------------------
// s
void AnzuDeathState::run(){
	// 萔
	float animationScale = 1.f;

	// Xe[gύX
	if(runCounter_ == 90){
		if(!isAnnihilated()){
			// SłłȂΕ
			setLife(getLife() - 1);
			setHealth(500);
			getPlayer()->setState(
				new AnzuGetUpState(getAnzu()));
		}else{
			// S
		}
	}

	// ʒuƑx̌vZ
	calcVelocityAndPosition(Vector3::zero);
	// ̐ݒ
//	setDirection(-damageDirection_);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);

	// sJE^CNg
	runCounter_++;
}
//------------------------------------------------------------------------------
