//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AY_[WԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/Anzu/AnzuBigDamageState.h"
#include "Game/Sound/SoundSystem.h"
#include "Player/System/Player.h"

#include "Player/Anzu/AnzuDeathState.h"
#include "Player/Anzu/AnzuGetUpState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AnzuBigDamageState::AnzuBigDamageState(Anzu* anzu) : AnzuState(anzu){
}
//------------------------------------------------------------------------------
// fXgN^
AnzuBigDamageState::~AnzuBigDamageState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void AnzuBigDamageState::initialize(){
	// ̐ݒ
	Vector3 direction = -getDamageDirection();
	direction.y = 0.f;
	setDirection(direction);
	clearDamage();
	// Aj[VV[PXݒ
	getAnimation()->setSequence(4);
	// sJE^NA
	runCounter_ = 0;
	// x̏
	setVelocity(Vector3(0.f, 2.5f, 0.f));
	// 炷
	getSoundSystem()->play("AnzuBigDamage");
}
//------------------------------------------------------------------------------
// n
void AnzuBigDamageState::finalize(){
}
//------------------------------------------------------------------------------
// s
void AnzuBigDamageState::run(){
	// 萔
	float animationScale = 1.f;

	// Xe[gύX
	if(runCounter_ == 120){
		if(isDeath()){
			// S
			getPlayer()->setState(new AnzuDeathState(getAnzu()));
		}else{
			// łȂ΋Nオ
			getPlayer()->setState(new AnzuGetUpState(getAnzu()));
		}
	}

	// ʒuƑx̌vZ
	float rate = (1.f - ((float)runCounter_ / 120.f)) * 0.4f;
	calcVelocityAndPosition(-getDirection() * rate);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);

	// sJE^CNg
	runCounter_++;
}
//------------------------------------------------------------------------------
