//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AYUԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/Anzu/AnzuAttackState.h"
#include "Game/Sound/SoundSystem.h"
#include "Player/System/Player.h"
#include "Stage/System/Stage.h"

#include "Player/Anzu/AnzuStandState.h"
#include "Player/Anzu/AnzuRunState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AnzuAttackState::AnzuAttackState(Anzu* anzu) : AnzuState(anzu){
}
//------------------------------------------------------------------------------
// fXgN^
AnzuAttackState::~AnzuAttackState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void AnzuAttackState::initialize(){
	// Aj[VV[PXݒ
	getAnimation()->setSequence(2);
	// sJE^NA
	runCounter_ = 0;
}
//------------------------------------------------------------------------------
// n
void AnzuAttackState::finalize(){
	// RW𖳌ɖ߂
	getAttackCollision()->setEnabled(false);
}
//------------------------------------------------------------------------------
// s
void AnzuAttackState::run(){
	// U炷
	if(runCounter_ == 10){ getSoundSystem()->play("AnzuAttack"); }

	// 萔
	float animationScale = 2.f;
	float moveXZScale = 0.01f;

	// Xe[gύX
	Point2f moveStick = getMoveStick();
	if(!isDamaged()){
		if(runCounter_ == 30){
			if(moveStick == Point2f::zero){
				getPlayer()->setState(new AnzuStandState(getAnzu()));
			}else{
				getPlayer()->setState(new AnzuRunState(getAnzu()));
			}
		}
	}

	// ړxNgZo
	Vector3 moveVelocity(moveStick.x, 0.f, moveStick.y);
	moveVelocity *= moveXZScale;

	// ʒuƑx̌vZ
	calcVelocityAndPosition(moveVelocity);
	// ̐ݒ
	setDirection(moveVelocity);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);

	// U
	if(runCounter_ == 10){ getAttackCollision()->setEnabled(true); }
	if(runCounter_ == 25){ getAttackCollision()->setEnabled(false); }
	float range = 9.f;
	if(getAttackCollision()->isEnabled()){
		attackCollide(getRightHandBone(),
			Vector3(0.f, range, range), range, 100);
	}

	// sJE^CNg
	runCounter_++;
}
//------------------------------------------------------------------------------
