//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AY
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Player/Anzu/Anzu.h"
#include "Game/System/GameSystem.h"
#include "Game/Rendering/RenderingSystem.h"
#include "Game/Animation/AnimationSystem.h"
#include "Game/Sound/SoundSystem.h"
#include "Load/System/LoadTask.h"
#include "Game/Input/GamePad.h"
#include "Player/Anzu/AnzuStandState.h"

//------------------------------------------------------------------------------
// RXgN^
Anzu::Anzu() : Player(), umbrella_(NULL){
	String name("Anzu");
	// f̏
	initializeModel(name);

	// P̏
	SceneNode* nodeSource =
		getScene()->getSceneNodeManager()->search("AnzuKasa");
	Assert(nodeSource != NULL);
	umbrella_ = nodeSource->copy();
	getSceneNode()->addSceneNode(umbrella_);

	// Aj[V̏
	initializeAnimation(name);

	// RWm[h̏
	initializeCollision(name, 5.f, 4.f);

	// Kȏʒu
	setPosition(Vector3(0.f, 10.f, 0.f));
	getCollisionNode()->setTranslation(getPosition());
	getSceneNode()->setTranslation(getPosition());

	// Ԃ̐ݒ
	AnzuState* state = new AnzuStandState(this);
	setState(state);
}
//------------------------------------------------------------------------------
// fXgN^
Anzu::~Anzu(){
	// P̔j
	SceneNode::recursiveDestroy(umbrella_);
}
//------------------------------------------------------------------------------
// [h
void Anzu::load(SceneNode* playerNode){
	LoadTask* loadTask = getGameSystem()->getLoadTask();
	// [h^XN̓o^
	loadTask->requestScene(
		"Media/Player/Anzu/Anzu.bsn", getScene(), playerNode);
	loadTask->requestAnimation("Media/Player/Anzu/Anzu.bam",
		getAnimationManager(), getScene());
	loadTask->requestScene(
		"Media/Player/Anzu/AnzuKasa.bsn", getScene(), playerNode);
}
//------------------------------------------------------------------------------
