//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * [h^XNwb_
 * @author Junpee
 */

#ifndef LOAD_TASK_H_
#define LOAD_TASK_H_

#include "Game/System/GameTask.h"

class LoadRequest;

//------------------------------------------------------------------------------
/**
 * [h^XN
 */
class LoadTask : public GameTask{
friend class GameSystem;
public:
	//--------------------------------------------------------------------------
	// ̃^XN
	//--------------------------------------------------------------------------
	/**
	 * ̃^XNݒ
	 * @param nextTask ̃^XN
	 */
	virtual void setNextTask(GameTask* nextTask){
		Assert((nextTask_ == NULL) && (nextTask != NULL));
		nextTask_ = nextTask;
	}

	//--------------------------------------------------------------------------
	// [hNGXg
	//--------------------------------------------------------------------------
	/**
	 * V[̃NGXg
	 * @param fileName t@C
	 * @param scene [hV[
	 * @param sceneNode [hV[m[h
	 */
	virtual void requestScene(const String& fileName, Scene* scene,
		SceneNode* sceneNode);

	//--------------------------------------------------------------------------
	/**
	 * Aj[ṼNGXg
	 * @param fileName t@C
	 * @param animationManager [hAj[V}l[W
	 * @param bindScene oChV[
	 */
	virtual void requestAnimation(const String& fileName,
		AnimationManager* animationManager, Scene* bindScene = NULL);

	//--------------------------------------------------------------------------
	/**
	 * RW̃NGXg
	 * @param fileName t@C
	 * @param scene [hV[
	 * @param collisionNode [hRWm[h
	 */
	virtual void requestCollision(const String& fileName,
		CollisionScene* scene, CollisionNode* collisionNode);

	//--------------------------------------------------------------------------
	/**
	 * TEhXg̃NGXg
	 * @param fileName t@C
	 * @param soundCache [hTEhLbV
	 */
	virtual void requestSoundList(
		const String& fileName, SoundCache* soundCache);

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	LoadTask();

	/**
	 * fXgN^
	 */
	virtual ~LoadTask();

	//--------------------------------------------------------------------------
	// An
	//--------------------------------------------------------------------------
	/**
	 * 
	 */
	virtual void initialize();

	/**
	 * n
	 */
	virtual void finalize();

	//--------------------------------------------------------------------------
	// s
	//--------------------------------------------------------------------------
	/**
	 * s
	 */
	virtual void run();

	//--------------------------------------------------------------------------
	// `揀
	//--------------------------------------------------------------------------
	/**
	 * `揀
	 */
	virtual void renderSetup();

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * `
	 */
	virtual void render();

private:
	//--------------------------------------------------------------------------
	// NGXg
	Deque<LoadRequest*> requests_;
	// JgNGXg
	LoadRequest* currentRequest_;
	// SNGXg
	int totalRequestCount_;
	// ̃^XN
	GameTask* nextTask_;
	// `JE^
	int drawCounter_;

};

//------------------------------------------------------------------------------
#endif // End of LOAD_TASK_H_
//------------------------------------------------------------------------------

