//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * [h^XN
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Load/System/LoadTask.h"
#include "Game/System/GameSystem.h"
#include "Game/Rendering/RenderingSystem.h"
#include "Load/Request/SceneLoadRequest.h"
#include "Load/Request/AnimationLoadRequest.h"
#include "Load/Request/CollisionLoadRequest.h"
#include "Load/Request/SoundListLoadRequest.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
LoadTask::LoadTask() : currentRequest_(NULL), totalRequestCount_(0),
	nextTask_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
LoadTask::~LoadTask(){
}
//------------------------------------------------------------------------------
// An
//------------------------------------------------------------------------------
// 
void LoadTask::initialize(){
	Assert(currentRequest_ == NULL);
	Assert(totalRequestCount_ == 0);
	Assert(nextTask_ != NULL);
	// NGXgꍇ́Ã^XNֈڍs
	totalRequestCount_ = requests_.getCount();
	if(totalRequestCount_ == 0){
		getGameSystem()->setNextTask(nextTask_);
		return;
	}
	// Jg̃NGXgݒ
	currentRequest_ = requests_.popFront();

	drawCounter_ = 0;
}
//------------------------------------------------------------------------------
// n
void LoadTask::finalize(){
	// ̃^XNNA
	nextTask_ = NULL;
	// NGXgNA
	SafeDelete(currentRequest_);
	int requestCount = requests_.getCount();
	for(int i = 0; i < requestCount; i++){ SafeDelete(requests_.get(i)); }
	requests_.clear();
	totalRequestCount_ = 0;
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// s
void LoadTask::run(){
	// x`悳܂ł͏Ȃ
	if(drawCounter_ < 2){ return; }

	if(currentRequest_->load()){
		// [hÎŃJgNGXg폜
		SafeDelete(currentRequest_);
		// NGXgXg烊NGXgoăJgɐݒ
		if(requests_.getCount() != 0){ currentRequest_ = requests_.popFront(); }
		drawCounter_ = 0;
	}

	// SNGXg̃[hI玟̃^XNֈڍs
	if((requests_.getCount() == 0) && (currentRequest_ == NULL)){
		Assert(nextTask_ != NULL);
		getGameSystem()->setNextTask(nextTask_);
	}
}
//------------------------------------------------------------------------------
// `揀
//------------------------------------------------------------------------------
// `揀
void LoadTask::renderSetup(){
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// `
void LoadTask::render(){
	// wiNA
	RenderingSystem::getInstance()->clearBackground();
	// [fBObZ[W
	String loadingMessage;
	loadingMessage.format("Now Loading...  %2d / %2d\n",
		totalRequestCount_ - requests_.getCount(), totalRequestCount_);
	DebugHUD::setBottomRight(loadingMessage);
	drawCounter_++;
}
//------------------------------------------------------------------------------
// [hNGXg
//------------------------------------------------------------------------------
// V[̃NGXg
void LoadTask::requestScene(const String& fileName, Scene* scene,
	SceneNode* sceneNode){
	SceneLoadRequest* request =
		new SceneLoadRequest(fileName, scene, sceneNode);
	requests_.pushBack(request);
}
//------------------------------------------------------------------------------
// Aj[ṼNGXg
void LoadTask::requestAnimation(const String& fileName,
	AnimationManager* animationManager, Scene* bindScene){
	AnimationLoadRequest* request =
		new AnimationLoadRequest(fileName, animationManager, bindScene);
	requests_.pushBack(request);
}
//------------------------------------------------------------------------------
// RW̃NGXg
void LoadTask::requestCollision(const String& fileName,
	CollisionScene* scene, CollisionNode* collisionNode){
	CollisionLoadRequest* request =
		new CollisionLoadRequest(fileName, scene, collisionNode);
	requests_.pushBack(request);
}
//------------------------------------------------------------------------------
// TEhXg̃NGXg
void LoadTask::requestSoundList(const String& fileName, SoundCache* soundCache){
	SoundListLoadRequest* request =
		new SoundListLoadRequest(fileName, soundCache);
	requests_.pushBack(request);
}
//------------------------------------------------------------------------------
