//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[[hNGXg
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Load/Request/SceneLoadRequest.h"
#include "Game/Rendering/RenderingSystem.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
SceneLoadRequest::SceneLoadRequest(
	const String& fileName, Scene* scene, SceneNode* sceneNode) :
	LoadRequest(), fileName_(fileName), scene_(scene), sceneNode_(sceneNode){
	Assert((scene_ != NULL) && (sceneNode != NULL));
}
//------------------------------------------------------------------------------
// fXgN^
SceneLoadRequest::~SceneLoadRequest(){
	// [h̒fɂ͑ΉȂ
	Assert(scene_ == NULL);
}
//------------------------------------------------------------------------------
// [h
//------------------------------------------------------------------------------
// [h
bool SceneLoadRequest::load(){
	// t@CpX̃`FbN
	FilePath filePath(fileName_);
	if(!filePath.existFile()){
		ErrorOut("SceneLoadRequest::load() V[t@C܂ %s",
			filePath.getPath().getBytes());
		return true;
	}

	// V[̃[h
	if(filePath.getExtension() == "tsn"){
		TextSceneLoader* loader = new TextSceneLoader();
		loader->load(filePath.getPath(), scene_, sceneNode_);
		delete loader;
	}else if(filePath.getExtension() == "bsn"){
		BinarySceneLoader* loader = new BinarySceneLoader();
		loader->load(filePath.getPath(), scene_, sceneNode_);
		delete loader;
	}else{
		ErrorOut("SceneLoadRequest::load() "
			"gqV[t@Cł͂܂ %s",
			filePath.getPath().getBytes());
		return true;
	}
	// IɃV[|C^NA
	scene_ = NULL;
	sceneNode_ = NULL;
	return true;
}
//------------------------------------------------------------------------------
