//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RW[hNGXgwb_
 * @author Junpee
 */

#ifndef COLLISION_LOAD_REQUEST_H_
#define COLLISION_LOAD_REQUEST_H_

#include "Load/Request/LoadRequest.h"

//------------------------------------------------------------------------------
/**
 * RW[hNGXg
 */
class CollisionLoadRequest : public LoadRequest{
friend class LoadTask;
public:
protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param fileName t@C
	 * @param scene [hRW
	 * @param collisionNode [hRWm[h
	 */
	CollisionLoadRequest(const String& fileName, CollisionScene* scene,
		CollisionNode* collisionNode);

	/**
	 * fXgN^
	 */
	virtual ~CollisionLoadRequest();

	//--------------------------------------------------------------------------
	// [h
	//--------------------------------------------------------------------------
	/**
	 * [h
	 * @return [hĂtrue
	 */
	virtual bool load();

private:
	//--------------------------------------------------------------------------
	// t@C
	String fileName_;
	// RWV[
	CollisionScene* scene_;
	// RWm[h
	CollisionNode* collisionNode_;
};

//------------------------------------------------------------------------------
#endif // End of COLLISION_LOAD_REQUEST_H_
//------------------------------------------------------------------------------

