//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RW[hNGXg
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Load/Request/CollisionLoadRequest.h"
#include "Game/Rendering/RenderingSystem.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
CollisionLoadRequest::CollisionLoadRequest(const String& fileName,
	CollisionScene* scene, CollisionNode* collisionNode) : LoadRequest(),
	fileName_(fileName), scene_(scene), collisionNode_(collisionNode){
	Assert((scene_ != NULL) && (collisionNode_ != NULL));
}
//------------------------------------------------------------------------------
// fXgN^
CollisionLoadRequest::~CollisionLoadRequest(){
	// [h̒fɂ͑ΉȂ
	Assert(scene_ == NULL);
}
//------------------------------------------------------------------------------
// [h
//------------------------------------------------------------------------------
// [h
bool CollisionLoadRequest::load(){
	// t@CpX̃`FbN
	FilePath filePath(fileName_);
	if(!filePath.existFile()){
		ErrorOut("CollisionLoadRequest::load() "
			"RWt@C܂ %s",
			filePath.getPath().getBytes());
		return true;
	}

	// RW̃[h
	if(filePath.getExtension() == "tcl"){
		TextCollisionLoader* loader = new TextCollisionLoader();
		loader->load(filePath.getPath(), scene_, collisionNode_);
		delete loader;
	}else{
		ErrorOut("CollisionLoadRequest::load() "
			"gqRWt@Cł͂܂ %s",
			filePath.getPath().getBytes());
		return true;
	}

	// IɃRW|C^NA
	scene_ = NULL;
	return true;
}
//------------------------------------------------------------------------------
