//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Aj[V[hNGXg
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Load/Request/AnimationLoadRequest.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AnimationLoadRequest::AnimationLoadRequest(const String& fileName,
	AnimationManager* animationManager, Scene* bindScene) :
	LoadRequest(), fileName_(fileName), animationManager_(animationManager),
	bindScene_(bindScene){
}
//------------------------------------------------------------------------------
// fXgN^
AnimationLoadRequest::~AnimationLoadRequest(){
	// [h̒fɂ͑ΉȂ
	Assert(animationManager_ == NULL);
}
//------------------------------------------------------------------------------
// [h
//------------------------------------------------------------------------------
// [h
bool AnimationLoadRequest::load(){
	// t@CpX̃`FbN
	FilePath filePath(fileName_);
	if(!filePath.existFile()){
		ErrorOut("AnimationLoadRequest::load() "
			"Aj[Vt@C܂ %s",
			filePath.getPath().getBytes());
		return true;
	}

	// Aj[Ṽ[h
	if(filePath.getExtension() == "tam"){
		TextAnimationLoader* loader = new TextAnimationLoader();
		loader->load(filePath.getPath(), animationManager_);
		delete loader;
	}else if(filePath.getExtension() == "bam"){
		BinaryAnimationLoader* loader = new BinaryAnimationLoader();
		loader->load(filePath.getPath(), animationManager_);
		delete loader;
	}else{
		ErrorOut("AnimationLoadRequest::load() "
			"gqAj[Vt@Cł͂܂ %s",
			filePath.getPath().getBytes());
		return true;
	}

	// Aj[ṼoCh
	Animation* animation = animationManager_->search(filePath.getName());
	if((animation != NULL) && (bindScene_ != NULL)){
		if(!animation->bind(bindScene_)){
			ErrorOut("AnimationLoadRequest::load() "
				"Aj[ṼoChɎs܂ %s",
				filePath.getPath().getBytes());
			animationManager_->clear();
			return true;
		}
	}

	// IɃAj[V|C^NA
	animationManager_ = NULL;
	return true;
}
//------------------------------------------------------------------------------
