//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * VXeQƃwb_
 * @author Junpee
 */

#ifndef SYSTEM_REFERENCE_H_
#define SYSTEM_REFERENCE_H_

class GameSystem;
class RenderingSystem;
class AnimationSystem;
class CollisionSystem;
class InputSystem;
class GamePad;
class SoundSystem;
class PlayerSystem;
class EnemySystem;

//------------------------------------------------------------------------------
/**
 * VXeQ
 */
class SystemReference{
protected:
	//--------------------------------------------------------------------------
	// Q[VXe
	//--------------------------------------------------------------------------
	/**
	 * Q[VXe̎擾
	 * @return Q[VXe
	 */
	static GameSystem* getGameSystem();

	//--------------------------------------------------------------------------
	// _O
	//--------------------------------------------------------------------------
	/**
	 * _OVXe̎擾
	 * @return _OVXe
	 */
	static RenderingSystem* getRenderingSystem();

	/**
	 * V[̎擾
	 * @return V[
	 */
	static Scene* getScene();

	//--------------------------------------------------------------------------
	// Aj[V
	//--------------------------------------------------------------------------
	/**
	 * Aj[VVXe̎擾
	 * @return Aj[VVXe
	 */
	static AnimationSystem* getAnimationSystem();

	/**
	 * Aj[V}l[W̎擾
	 * @return Aj[V}l[W
	 */
	static AnimationManager* getAnimationManager();

	//--------------------------------------------------------------------------
	// RW
	//--------------------------------------------------------------------------
	/**
	 * RWVXe̎擾
	 * @return RWVXe
	 */
	static CollisionSystem* getCollisionSystem();

	/**
	 * RWV[̎擾
	 * @return RWV[
	 */
	static CollisionScene* getCollisionScene();

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̓VXe̎擾
	 * @return ̓VXe
	 */
	static InputSystem* getInputSystem();

	/**
	 * Q[pbh̎擾
	 * @return Q[pbh
	 */
	static GamePad* getGamePad();

	/**
	 * L[{[h̎擾
	 * @return L[{[h
	 */
	static Keyboard* getKeyboard();

	/**
	 * }EX̎擾
	 * @return }EX
	 */
	static Mouse* getMouse();

	//--------------------------------------------------------------------------
	// TEh
	//--------------------------------------------------------------------------
	/**
	 * TEhVXe̎擾
	 * @return TEhVXe
	 */
	static SoundSystem* getSoundSystem();

	/**
	 * TEh}l[W̎擾
	 * @returh TEh}l[W
	 */
	static SoundManager* getSoundManager();

	//--------------------------------------------------------------------------
	// vC
	//--------------------------------------------------------------------------
	/**
	 * vCVXe̎擾
	 * @return vCVXe
	 */
	static PlayerSystem* getPlayerSystem();

	//--------------------------------------------------------------------------
	// G
	//--------------------------------------------------------------------------
	/**
	 * GVXe̎擾
	 * @return GVXe
	 */
	static EnemySystem* getEnemySystem();

};

//------------------------------------------------------------------------------
#endif // End of SYSTEM_REFERENCE_H_
//------------------------------------------------------------------------------

