//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software{ you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation{ either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY{ without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library{ if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * VXeQƎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Game/System/SystemReference.h"
#include "Game/System/GameSystem.h"
#include "Game/Rendering/RenderingSystem.h"
#include "Game/Animation/AnimationSystem.h"
#include "Game/Collision/CollisionSystem.h"
#include "Game/Input/InputSystem.h"
#include "Game/Sound/SoundSystem.h"
#include "Player/System/PlayerSystem.h"
#include "Enemy/System/EnemySystem.h"

//------------------------------------------------------------------------------
// Q[VXe
//------------------------------------------------------------------------------
// Q[VXe̎擾
GameSystem* SystemReference::getGameSystem(){
	return GameSystem::getInstance();
}
//------------------------------------------------------------------------------
// _O
//------------------------------------------------------------------------------
// _OVXe̎擾
RenderingSystem* SystemReference::getRenderingSystem(){
	return RenderingSystem::getInstance();
}
//------------------------------------------------------------------------------
// V[̎擾
Scene* SystemReference::getScene(){
	return RenderingSystem::getInstance()->getScene();
}
//------------------------------------------------------------------------------
// Aj[V
//------------------------------------------------------------------------------
// Aj[VVXe̎擾
AnimationSystem* SystemReference::getAnimationSystem(){
	return AnimationSystem::getInstance();
}
//------------------------------------------------------------------------------
// Aj[V}l[W̎擾
AnimationManager* SystemReference::getAnimationManager(){
	return AnimationSystem::getInstance()->getAnimationManager();
}
//------------------------------------------------------------------------------
// RW
//------------------------------------------------------------------------------
// RWVXe̎擾
CollisionSystem* SystemReference::getCollisionSystem(){
	return CollisionSystem::getInstance();
}
//------------------------------------------------------------------------------
// RWV[̎擾
CollisionScene* SystemReference::getCollisionScene(){
	return CollisionSystem::getInstance()->getScene();
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// ̓VXe̎擾
InputSystem* SystemReference::getInputSystem(){
	return InputSystem::getInstance();
}
//------------------------------------------------------------------------------
// Q[pbh̎擾
GamePad* SystemReference::getGamePad(){
	return InputSystem::getInstance()->getGamePad();
}
//------------------------------------------------------------------------------
// L[{[h̎擾
Keyboard* SystemReference::getKeyboard(){
	return InputSystem::getInstance()->getKeyboard();
}
//------------------------------------------------------------------------------
// }EX̎擾
Mouse* SystemReference::getMouse(){
	return InputSystem::getInstance()->getMouse();
}
//------------------------------------------------------------------------------
// TEh
//------------------------------------------------------------------------------
// TEhVXe̎擾
SoundSystem* SystemReference::getSoundSystem(){
	return SoundSystem::getInstance();
}
//------------------------------------------------------------------------------
// TEh}l[W̎擾
SoundManager* SystemReference::getSoundManager(){
	return SoundSystem::getInstance()->getSoundManager();
}
//------------------------------------------------------------------------------
// vC
//------------------------------------------------------------------------------
// vCVXe̎擾
PlayerSystem* SystemReference::getPlayerSystem(){
	return PlayerSystem::getInstance();
}
//------------------------------------------------------------------------------
// G
//------------------------------------------------------------------------------
// GVXe̎擾
EnemySystem* SystemReference::getEnemySystem(){
	return EnemySystem::getInstance();
}
//------------------------------------------------------------------------------
