//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Q[VXewb_
 * @author Junpee
 */

#ifndef GAME_SYSTEM_H_
#define GAME_SYSTEM_H_

class RenderingSystem;
class AnimationSystem;
class CollisionSystem;
class InputSystem;
class SoundSystem;
class BGMSystem;
class PlayerSystem;
class EnemySystem;

class GameTask;
class Stage;
class TitleTask;
class LoadTask;
class Player;

//------------------------------------------------------------------------------
/**
 * Q[VXe
 */
class GameSystem{
friend class PrismaticUmbrella;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X̎擾
	 * @return CX^X
	 */
	static GameSystem* getInstance(){ return instance_; }

	//--------------------------------------------------------------------------
	// VXe
	//--------------------------------------------------------------------------
	/**
	 * _OVXe̎擾
	 * @return _OVXe
	 */
	virtual RenderingSystem* getRenderingSystem(){ return renderingSystem_; }

	/**
	 * Aj[VVXe̎擾
	 * @return Aj[VVXe
	 */
	virtual AnimationSystem* getAnimationSystem(){ return animationSystem_; }

	/**
	 * RWVXe̎擾
	 * @return RWVXe
	 */
	virtual CollisionSystem* getCollisionSystem(){ return collisionSystem_; }

	/**
	 * ̓VXe̎擾
	 * @return ̓VXe
	 */
	virtual InputSystem* getInputSystem(){ return inputSystem_; }

	/**
	 * TEhVXe̎擾
	 * @return TEhVXe
	 */
	virtual SoundSystem* getSoundSystem(){ return soundSystem_; }

	/**
	 * vCVXe̎擾
	 * @return vCVXe
	 */
	virtual PlayerSystem* getPlayerSystem(){ return playerSystem_; }

	/**
	 * GVXe̎擾
	 * @return GVXe
	 */
	virtual EnemySystem* getEnemySystem(){ return enemySystem_; }

	//--------------------------------------------------------------------------
	// ^XN
	//--------------------------------------------------------------------------
	/**
	 * ̃^XNݒ
	 * @param nextTask ̃^XN
	 */
	virtual void setNextTask(GameTask* nextTask);

	//--------------------------------------------------------------------------
	/**
	 * EqXe[W擾
	 * @return EqXe[W
	 */
	virtual Stage* getSporeStage(){ return sporeStage_; }

	//--------------------------------------------------------------------------
	/**
	 * ^Cg^XN擾
	 * @return ^Cg^XN
	 */
	virtual TitleTask* getTitleTask(){ return titleTask_; }

	//--------------------------------------------------------------------------
	/**
	 * [h^XN擾
	 * @return [h^XN
	 */
	virtual LoadTask* getLoadTask(){ return loadTask_; }

	//--------------------------------------------------------------------------
	// s
	//--------------------------------------------------------------------------
	/**
	 * s
	 */
	virtual void run();

	//--------------------------------------------------------------------------
	// `揀
	//--------------------------------------------------------------------------
	/**
	 * `揀
	 */
	virtual void renderSetup();

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * `
	 */
	virtual void render();

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	GameSystem();

	/**
	 * fXgN^
	 */
	virtual ~GameSystem();

	//--------------------------------------------------------------------------
	/**
	 * VXe
	 */
	virtual void systemInput();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	GameSystem(const GameSystem& copy);

	// Rs[̉B
	void operator =(const GameSystem& copy);

	// _OVXe
	RenderingSystem* renderingSystem_;
	// Aj[VVXe
	AnimationSystem* animationSystem_;
	// RWVXe
	CollisionSystem* collisionSystem_;
	// ̓VXe
	InputSystem* inputSystem_;
	// TEhVXe
	SoundSystem* soundSystem_;
	// vCVXe
	PlayerSystem* playerSystem_;
	// GVXe
	EnemySystem* enemySystem_;

	// Jg^XN
	GameTask* currentTask_;
	// ̃^XN
	GameTask* nextTask_;
	// EqXe[W
	Stage* sporeStage_;
	// ^Cg^XN
	TitleTask* titleTask_;
	// [h^XN
	LoadTask* loadTask_;

	// CX^X
	static GameSystem* instance_;

};

//------------------------------------------------------------------------------
#endif // End of GAME_SYSTEM_H_
//------------------------------------------------------------------------------
