//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Q[VXe
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Game/System/GameSystem.h"
// VXe
#include "Game/Rendering/RenderingSystem.h"
#include "Game/Animation/AnimationSystem.h"
#include "Game/Collision/CollisionSystem.h"
#include "Game/Input/InputSystem.h"
#include "Game/Sound/SoundSystem.h"
#include "Player/System/PlayerSystem.h"
#include "Enemy/System/EnemySystem.h"
// ^XN
#include "Game/System/GameTask.h"
#include "Stage/Spore/SporeStage.h"
#include "Title/TitleTask.h"
#include "Load/System/LoadTask.h"
// ̑
#include "Core/Utility/Performance.h"

// CX^X
GameSystem* GameSystem::instance_ = NULL;

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
GameSystem::GameSystem() : currentTask_(NULL), nextTask_(NULL){
	// CX^X|C^ݒ
	Assert(instance_ == NULL);
	instance_ = this;
	// eVXe
	renderingSystem_ = new RenderingSystem();
	animationSystem_ = new AnimationSystem();
	collisionSystem_ = new CollisionSystem();
	inputSystem_ = new InputSystem();
	soundSystem_ = new SoundSystem();
	playerSystem_ = new PlayerSystem();
	enemySystem_ = new EnemySystem();

	// ^XN̐
	sporeStage_ = new SporeStage();
	titleTask_ = new TitleTask();
	loadTask_ = new LoadTask();

	// Jg^XÑZbgAbv
//	getSporeStage()->load();
	getTitleTask()->load();
	Assert(nextTask_ != NULL);
	currentTask_ = nextTask_;
	nextTask_ = NULL;
	currentTask_->initialize();
}
//------------------------------------------------------------------------------
// fXgN^
GameSystem::~GameSystem(){
	// Jg^XŇn
	currentTask_->finalize();

	// ^XN̔j
	SafeDelete(loadTask_);
	SafeDelete(titleTask_);
	SafeDelete(sporeStage_);

	// eVXej
	SafeDelete(enemySystem_);
	SafeDelete(playerSystem_);
	SafeDelete(soundSystem_);
	SafeDelete(inputSystem_);
	SafeDelete(collisionSystem_);
	SafeDelete(animationSystem_);
	SafeDelete(renderingSystem_)
	// CX^X|C^n
	Assert(instance_ == this);
	instance_ = NULL;
}
//------------------------------------------------------------------------------
// ^XN
//------------------------------------------------------------------------------
// ̃^XNݒ
void GameSystem::setNextTask(GameTask* nextTask){
	Assert((nextTask != NULL) && (nextTask_ == NULL));
	nextTask_ = nextTask;
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// s
void GameSystem::run(){
	// VXe
	systemInput();

	// ^XN̐؂ւ
	while(nextTask_ != NULL){
		currentTask_->finalize();
		currentTask_ = nextTask_;
		nextTask_ = NULL;
		// initializeŎ̃^XNݒ肷邱Ƃ\
		currentTask_->initialize();
	}

	// ^XN̎s
	Assert(currentTask_ != NULL);
	currentTask_->run();
}
//------------------------------------------------------------------------------
// VXe
void GameSystem::systemInput(){
	Keyboard* keyboard = LampInput::getKeyboard();

	// Alt+EnterL[ŃtXN[ؑ
	if(keyboard->down(Keyboard::keyEnter) &&
		(keyboard->pressed(Keyboard::keyLeftAlt) ||
		keyboard->pressed(Keyboard::keyRightAlt))){
		GraphicsDevice::getInstance()->toggleFullscreen();
	}

	// EscL[ŏI
	if(keyboard->down(Keyboard::keyEscape)){ PostQuitMessage(0); }

#ifdef _DEBUG
	// F9L[ŃfoCXč\z
	if(keyboard->down(Keyboard::keyF9)){
		GraphicsDevice::getInstance()->rebuild();
	}
#endif
}
//------------------------------------------------------------------------------
// `揀
//------------------------------------------------------------------------------
// `揀
void GameSystem::renderSetup(){
	// ^XN̕`揀
	Assert(currentTask_ != NULL);
	currentTask_->renderSetup();
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// `
void GameSystem::render(){
	// ^XN̕`
	Assert(currentTask_ != NULL);
	currentTask_->render();

	// FPS̕\
	DebugHUD::setTopRight(Performance::getFPSString());
	if(Performance::getDrawFPS() < 20.f){
		DebugHUD::setTopRightColor(Color4c::red);
	}else if(Performance::getDrawFPS() < 55.f){
		DebugHUD::setTopRightColor(Color4c::yellow);
	}else{
		DebugHUD::setTopRightColor(Color4c::white);
	}
}
//------------------------------------------------------------------------------
