//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TEhVXewb_
 * @author Junpee
 */

#ifndef SOUND_SYSTEM_H_
#define SOUND_SYSTEM_H_

//------------------------------------------------------------------------------
/**
 * TEhVXe
 */
class SoundSystem{
friend class GameSystem;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X̎擾
	 * @return CX^X
	 */
	static SoundSystem* getInstance(){ return instance_; }

	//--------------------------------------------------------------------------
	/**
	 * TEh}l[W̎擾
	 * @return TEh}l[W
	 */
	virtual SoundManager* getSoundManager(){ return soundManager_; }

	//--------------------------------------------------------------------------
	/**
	 * Đ
	 * @param soundName TEh
	 */
	virtual void play(const String& soundName, float volume = 1.f){
		Sound* sound = stageSound_->playSound(soundName, volume);
		Assert(sound != NULL);
	}

	/**
	 * 
	 * @param soundName TEh
	 * @return TEhAȂNULL
	 */
	virtual Sound* search(const String& soundName){
		return stageSound_->getSound(soundName);
	}

	//--------------------------------------------------------------------------
	// Xe[WTEh
	//--------------------------------------------------------------------------
	/**
	 * Xe[WTEh̃[h
	 * @param fileName t@C
	 */
	virtual void loadStageSound(const String& fileName){
		stageSound_->loadSoundList(fileName);
	}

	/**
	 * Xe[WTEh̃A[h
	 */
	virtual void unloadStageSound(){ stageSound_->unloadAll(); }

	/**
	 * Xe[WTEh̎擾
	 * @return Xe[WTEh
	 */
	virtual SoundCache* getStageSound(){ return stageSound_; }

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	SoundSystem();

	/**
	 * fXgN^
	 */
	virtual ~SoundSystem();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	SoundSystem(const SoundSystem& copy);

	// Rs[̉B
	void operator =(const SoundSystem& copy);

	//--------------------------------------------------------------------------
	// TEh}l[W
	SoundManager* soundManager_;
	// Xe[WTEh
	SoundCache* stageSound_;

	// CX^X
	static SoundSystem* instance_;

};

//------------------------------------------------------------------------------
#endif // End of SOUND_SYSTEM_H_
//------------------------------------------------------------------------------
