//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TEhVXe
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Game/Sound/SoundSystem.h"

// CX^X
SoundSystem* SoundSystem::instance_ = NULL;

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
SoundSystem::SoundSystem(){
	// CX^X|C^ݒ
	Assert(instance_ == NULL);
	instance_ = this;

	soundManager_ = LampSound::getSoundManager();
	stageSound_ = new SoundCache("Media/SE/", ".ogg");
}
//------------------------------------------------------------------------------
// fXgN^
SoundSystem::~SoundSystem(){
	delete stageSound_;
	Assert(soundManager_->getCount() == 0);

	// CX^X|C^n
	Assert(instance_ == this);
	instance_ = NULL;
}
//------------------------------------------------------------------------------
